<?php

class Crossroads_API_Helper_Cms {

    public function getAll()
    {
        $store_id = Mage::app()->getStore()->getStoreId();
        $root_id  = Mage::app()->getStore($store_id)->getRootCategoryId();

        $pages = Mage::getModel('cms/page')
            ->getCollection()
            ->addStoreFilter($store_id)
            ->addFieldToFilter('is_active', 1);

        return array_map(function($page) {
            return [
                "id"         => (int)$page['page_id'],
                "title"      => $page['title'],
                "urlKey"     => $page['identifier'],
                "sortOrder"  => (int)$page['sort_order']
            ];
        }, $pages->getData());
    }

    public function getItem($id)
    {
        $page = Mage::getModel('cms/page')->load($id);

        if( ! $id) {
            return null;
        }

        return $this->prepareCmsPage($page);
    }

    public function getCategoryIdByUrlKey($url_key)
    {
        return Mage::getModel('cms/page')->checkIdentifier($url_key, Mage::app()->getStore()->getId());
    }

    public function prepareCmsPage($page) {
        $helper    = Mage::helper('cms');
        $data      = $page->getData();
        $processor = $helper->getPageTemplateProcessor();
        $html      = $processor->filter($page->content);

        return [
            "contentHeading"  => $data["content_heading"],
            "title"           => $data["title"],
            "urlKey"          => $data["identifier"],
            "isActive"        => $data["is_active"] > 0,
            "metaDescription" => $data["meta_description"],
            "metaKeywords"    => $data["meta_keywords"],
            "pageId"          => (int)$data["page_id"],
            "rootTemplate"    => $data["root_template"],
            "sortOrder"       => (int)$data["sort_order"],
            "createdAt"       => gmdate("Y-m-d\TH:i:s\Z", strtotime($data["creation_time"])),
            "updatedAt"       => gmdate("Y-m-d\TH:i:s\Z", strtotime($data["update_time"])),
            "html"            => $html
        ];
    }
}
