<?php

class Crossroads_API_Helper_Attributes {
    /**
     * Executed after an associated array has been prepared for the attribute-configuration,
     * this array can be modified.
     *
     * Params:
     *  * entity:        Entity
     *  * config:        Configuration array of frontend_input and attribute_code
     *  * prepared_data  The associated array as a varien object, note that data is in
     *                   camel-case, so use `setData` and `getData` to modify.
     */
    const EVENT_POST_DATA_PREPARE = "crossroads_api_attributes_post_data_prepare";

    /**
     * Fetches the user-configured entity attributes for the supplied entity.
     *
     * @param  Mage_Catalog_Model_Product|Mage_Catalog_Model_Customer
     * @param  array   Array with attribute_code and frontend_input
     * @return object
     */
    public function getEntityAttributes($entity, $config)
    {
        $attributes = [];

        foreach (($config ?: []) as $attribute) {
            if(!is_array($attribute) ||
                !array_key_exists("attribute_code", $attribute) ||
                !array_key_exists("frontend_input", $attribute)) {
                continue;
            }

            $code  = $attribute["attribute_code"];
            $input = $attribute["frontend_input"];

            switch($input) {
                case "select":
                    $attributes[$code] = $entity->getAttributeText($code) ?: null;
                    break;
                case "multiselect":
                    $attributes[$code] = $entity->getAttributeText($code) ?: null;
                    break;
                default:
                    $attributes[$code] = $entity->getData($code);
            }
        }

        $data = new Varien_Object($attributes);

        Mage::dispatchEvent(self::EVENT_POST_DATA_PREPARE, [
            "entity"        => $entity,
            "config"        => $config,
            "prepared_data" => $data,
        ]);

        return $data->getData() ?: new stdClass();
    }
}
