<?php

class Crossroads_API_Block_Options_Array extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    public function __construct()
    {
        $this->addColumn("attribute", [
            "label" => Mage::helper("API")->__("Attribute"),
            "style" => "width:350px",
        ]);

        $this->_addButtonLabel = Mage::helper("API")->__("Add Attribute");

        parent::__construct();

        $this->setTemplate("crossroads_api/array_select.phtml");

    }

    public function mkGridId() {
        return $this->getHtmlId() ? $this->getHtmlId() : "_" . uniqid();
    }

    public function getSelectOptions($selected) {
        return implode("\n", array_map(function($a) use ($selected) {
            $attr   = $a["attribute_code"];
            $active = $selected && $attr === $selected->getAttributeCode() ? " selected=\"selected\"" :"";

            return "<option value=\"{$attr}\"$active>{$a["frontend_label"]} ({$attr})</option>";
        }, $this->getElement()->getValues()));
    }

    public function getArrayRows()
    {
        $element = $this->getElement();

        if (!$element->getValue() || !is_array($element->getValue())) {
            return [];
        }

        return array_values(array_map(function($row) {
            return new Varien_Object($row);
        }, $element->getValue()));
    }

    public function getAttributes() {
        if(empty($this->getElement()->getValues())) {
            return new stdClass();
        }

        $ret = [];

        foreach($this->getElement()->getValues() as $attr) {
            $ret[$attr["attribute_code"]] = $attr;
        }

        return $ret;
    }
}
