<?php

class Crossroads_API_SearchController extends Crossroads_API_Controller_Super
{
    protected function getQueryModel($queryText) {
        $storeId = Mage::app()->getStore()->getId();
        $query   = Mage::getModel("catalogsearch/query");

        $query->setStoreId($storeId);
        $query->loadByQuery($queryText);

        if( ! $query->getId()) {
            $query->setQueryText($queryText);
            $query->setStoreId($storeId);
            $query->setPopularity(1);
        }
        else {
            $query->setPopularity($query->getPopularity() + 1);
        }

        $query->prepare();

        return $query;
    }

    /**
     * @api {get} /search?query=:query Search products
     * @apiName search
     * @apiGroup Search
     * @apiDescription We'll need to implement our own algorithm here later.
     *
     * @apiParam {String} query Search query
     *
     * @apiSuccess {Object[]} products Array of resulting products
     * @apiSuccess {Integer}  products.id Product id
     * @apiSuccess {String}   products.type Product type
     * @apiSuccess {String}   products.sku
     * @apiSuccess {String}   products.urlKey
     * @apiSuccess {Double}   products.price
     * @apiSuccess {Double}   products.specialPrice
     * @apiSuccess {Double}   products.msrp
     * @apiSuccess {Double}   products.discountPercent
     * @apiSuccess {String}   products.shortDescription
     * @apiSuccess {Mixed}    products.manufacturer String if a manufacturer is set, null otherwise
     * @apiSuccess {String}   products.smallImage
     * @apiSuccess {Boolean}  products.isSalable
     * @apiSuccess {Object[]} products.options  Null if simple product, object if complex, can be turned off in list view through System Configuration
     */
    public function indexAction() {
        $search_query = $this->getRequest()->getParam("query");

        if (!$search_query) {
            return $this->sendData([404]);
        }

        $helper = Mage::helper("API/product");
        $query  = $this->getQueryModel($search_query);

        $fulltextResource = Mage::getResourceModel('catalogsearch/fulltext')->prepareResult(
            Mage::getModel('catalogsearch/fulltext'),
            $search_query,
            $query
        );

        $matchedProductIds = array_keys($fulltextResource->getFoundData());

        $collection = Mage::getResourceModel('catalog/product_collection')
            ->addIdFilter($matchedProductIds)
            ->addAttributeToSelect('*')
            ->addMinimalPrice();

        $data = $collection->getItems();

        $query->save();

        return $this->sendData([200, [
            "products" => array_values(array_map(function($p) use($helper) {
                return $helper->prepareListProduct($p);
            }, $data)),
            "query" => $search_query
        ]]);
    }
}