<?php

class Crossroads_API_Helper_Brand
{
    public function prepareBrand($brand)
    {
        return [
            "urlKey" => urlencode($brand),
            "name"   => $brand
        ];
    }

    /**
     * Fetches a list of all brands containing active products in the store.
     *
     * NOTE: This uses the flat-tables to obtain a current list of brands.
     *
     * @param  int            Store id
     * @return Array<string>  Array of brand names
     */
    public function fetchAllBrands($store_id) {
        // TODO: Should be a model
        $db  = Mage::getSingleton('core/resource')->getConnection('core_read');
        $sql = "
            SELECT DISTINCT
                cpf.manufacturer_value
            FROM
                catalog_product_flat_$store_id cpf
            LEFT JOIN cataloginventory_stock_item csi ON csi.product_id = cpf.entity_id
            WHERE
                cpf.status = 1
            AND cpf.type_id = 'simple'
            AND    ((csi.is_in_stock = 1
            AND csi.qty > 0) OR csi.manage_stock = 0)
            AND cpf.manufacturer_value IS NOT NULL
            ORDER BY cpf.manufacturer_value ASC";

        return $db->query($sql)->fetchAll(Zend_Db::FETCH_COLUMN);
    }
}
