<?php

/**
 * Wrapper-controller separating payment-callback logic into separate controller classes for
 * each payment method.
 *
 * Routing: /api/payment/:type/:action
 */
class Crossroads_API_PaymentController extends Crossroads_API_Controller_Super {
    public function indexAction() {
        return $this->sendData([404]);
    }

    // Using true here we tell Magento's router that we support all actions.
    public function hasAction($_action) { return true; }

    /**
     * Perform actual routing.
     */
    public function norouteAction($_coreRoute = null) {
        $req = $this->getRequest();

        if(strpos($req->getPathInfo(), Crossroads_API_Helper_Payment::BASE_URI) !== 0) {
            return $this->sendData([404]);
        }

        // Split up the path into controller and remaining URL
        $newReq     = clone $req;
        $relative   = trim(substr($req->getPathInfo(), strlen(Crossroads_API_Helper_Payment::BASE_URI)), "/");
        $segments   = explode("/", $relative);
        $controller = array_shift($segments);
        $action     = array_shift($segments) ?: "index";

        // Apply new parameters
        $newReq->clearParams();

        while(!empty($segments)) {
            $newReq->setParam(array_shift($segments), array_shift($segments) ?: "");
        }

        $paymentHelper = Mage::helper("API/payment");

        if( ! $paymentHelper->hasMethod($controller) ||
            ! $paymentHelper->getMethod($controller)->getControllerClassName()) {
            return $this->sendData([404]);
        }

        try {
            $className = $paymentHelper->getMethod($controller)->getControllerClassName();
            $instance  = Mage::getControllerInstance($className, $newReq, $this->getResponse());

            if(!$instance->hasAction($action)) {
                return $this->sendData([404]);
            }

            $instance->dispatch($action);
        }
        catch(Exception $e) {
            $this->handleException($e);
        }
    }
}
