<?php

class Crossroads_API_SearchController extends Crossroads_API_Controller_Super
{
    /**
     * @api {get} /search?query=:query Search products
     * @apiName search
     * @apiGroup Search
     * @apiDescription We'll need to implement our own algorithm here later.
     *
     * @apiParam {String} query Search query
     *
     * @apiSuccess {Object[]} products Array of resulting products
     * @apiSuccess {Integer}  products.id Product id
     * @apiSuccess {String}   products.type Product type
     * @apiSuccess {String}   products.sku
     * @apiSuccess {String}   products.urlKey
     * @apiSuccess {Double}   products.price
     * @apiSuccess {Double}   products.specialPrice
     * @apiSuccess {Double}   products.msrp
     * @apiSuccess {Double}   products.discountPercent
     * @apiSuccess {String}   products.shortDescription
     * @apiSuccess {Mixed}    products.manufacturer String if a manufacturer is set, null otherwise
     * @apiSuccess {String}   products.smallImage
     * @apiSuccess {Boolean}  products.isSalable
     * @apiSuccess {Object[]} products.options  Null if simple product, object if complex, can be turned off in list view through System Configuration
     */
    public function indexAction() {
        $search_query = $this->getRequest()->getParam("query");

        if (!$search_query) {
            return $this->sendData([404]);
        }

        $helper           = Mage::helper("API/product");
        $query            = Mage::getModel('catalogsearch/query')->setQueryText($search_query)->prepare();
        $fulltextResource = Mage::getResourceModel('catalogsearch/fulltext')->prepareResult(
            Mage::getModel('catalogsearch/fulltext'),
            $search_query,
            $query
        );

        $collection = Mage::getResourceModel('catalog/product_collection');
        $collection->getSelect()->joinInner(
            array('search_result' => $collection->getTable('catalogsearch/result')),
            $collection->getConnection()->quoteInto(
                'search_result.product_id=e.entity_id AND search_result.query_id=?',
                $query->getId()
            ),
            array('relevance' => 'relevance')
        );

        $collection->addAttributeToSelect('*')->addMinimalPrice();

        return $this->sendData([200, [
            "products" => array_values(array_map(function($p) use($helper) {
                return $helper->prepareListProduct($p);
            }, $collection->getItems())),
            "query" => $search_query
        ]]);
    }
}