<?php

class Crossroads_API_Block_Options_Array extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    protected $ATTRIBUTE_BLACKLIST = [
        "select",
        "name",
        "groups",
        "product_view",
        "fields",
        "attributes",
        "attribute",
        "class",
        "style",
        "category_ids",
        "cost",
        "country_of_manufacture",
        "created_at",
        "custom_design",
        "custom_design_from",
        "custom_design_to",
        "custom_layout_update",
        "description",
        "ebizmarts_mark_visited",
        "gallery",
        "gift_message_available",
        "group_price",
        "has_s",
        "image",
        "image_label",
        "is_recurring",
        "links_exist",
        "links_purchased_separately",
        "links_title",
        "media_gallery",
        "meta_description",
        "meta_keyword",
        "meta_title",
        "minimal_price",
        "modell",
        "msrp",
        "msrp_display_actual_price_type",
        "msrp_enabled",
        "news_from_date",
        "news_to_date",
        "old_id",
        "s_container",
        "page_layout",
        "price",
        "price_type",
        "price_view",
        "recurring_profile",
        "required_s",
        "samples_title",
        "shipment_type",
        "short_description",
        "sku",
        "sku_type",
        "small_image",
        "small_image_label",
        "special_from_date",
        "special_price",
        "special_to_date",
        "status",
        "tax_class_id",
        "thumbnail",
        "thumbnail_label",
        "tier_price",
        "updated_at",
        "url_key",
        "url_path",
        "visibility",
        "weight",
        "weight_type",
        "has_options",
        "options_container",
        "required_options"
    ];

    /**
     * List of attributes possible to select.
     */
    protected $attributes;

    public function __construct()
    {
        $blacklist  = $this->ATTRIBUTE_BLACKLIST;
        $attributes = Mage::getResourceModel("catalog/product_attribute_collection")->getItems();

        $this->attributes = array_filter(array_map(function($a) use($blacklist) {
            if(in_array($a->getAttributeCode(), $blacklist)) {
                return false;
            }

            return $a->getData();
        }, $attributes));

        $this->addColumn("attribute", [
            "label" => Mage::helper("API")->__("Attribute"),
            "style" => "width:350px",
        ]);

        $this->_addButtonLabel = Mage::helper("API")->__("Add Attribute");

        parent::__construct();

        $this->setTemplate("crossroads_api/array_select.phtml");

    }

    public function mkGridId() {
        return $this->getHtmlId() ? $this->getHtmlId() : "_" . uniqid();
    }

    public function getSelectOptions($selected) {
        return implode("\n", array_map(function($a) use ($selected) {
            $attr   = $a["attribute_code"];
            $active = $selected && $attr === $selected->getAttributeCode() ? " selected=\"selected\"" :"";

            return "<option value=\"{$attr}\"$active>{$a["frontend_label"]} ({$attr})</option>";
        }, $this->attributes));
    }

    public function getArrayRows()
    {
        $element = $this->getElement();

        if (!$element->getValue() || !is_array($element->getValue())) {
            return [];
        }

        return array_values(array_map(function($row) {
            return new Varien_Object($row);
        }, $element->getValue()));
    }

    public function getAttributes() {
        if(empty($this->attributes)) {
            return new stdClass();
        }

        $ret = [];

        foreach($this->attributes as $attr) {
            $ret[$attr["attribute_code"]] = $attr;
        }

        return $ret;
    }
}
