<?php

abstract class Crossroads_API_Payment_Abstract {
    const ORDER_STATUS_COMPLETE = "COMPLETE";
    const ORDER_IN_PROGRESS     = "IN_PROGRESS";
    const ORDER_FAILED          = "FAILED";

    /**
     * Returns one of the ORDER_* constants from this class depending on the order's payment status.
     */
    public function getOrderPaymentStatus($order) {
        switch($order->getStatus()) {
        case Mage_Sales_Model_Order::STATE_PENDING_PAYMENT:
            return self::ORDER_IN_PROGRESS;
        default:
            return self::ORDER_STATUS_COMPLETE;
        }
    }

    /**
     * Return falseish if the payment data is valid, if the response is trueish it will be
     * supplied as the value of the data key in a 400 response.
     */
    public abstract function isQuoteInvalid($quote);

    /**
     * Returns data for progressing payment. This method should match the `getOrderPaymentStatus`,
     * if it is ORDER_COMPLETE it should be null.
     */
    public abstract function getOrderPaymentData($order);
}
