# Documentation for error cores

The API will return an error code whenever a user-caused error occurs (ie. the HTTP status-code
is `< 500`).

Invalid Server Error (HTTP status-code 500) do not use this format unless Developer Mode is turned
on, and then they instead contain an exception and `errorCode = null`.

## Responses

The API will return an error in the style of:

```
{
  "message": "Human readable message intended for developers, not translated.",
  "errorCode": 1234,
  "data": null
}
```

### `message`

This message is not intended to be shown for normal users, it is technical in nature and
sheds some light on what went wrong. It is intended to be used by application-developers
when they need to fix issues where data might be missing, malformed or invalid.

### `errorCode`

This error code is unique per error, and grouped per error kind. To obtain messages for
normal users it is recommended to use this code to look up a suitable error message to
show.

A backup message might be necessary, for the case of when errors are missing error codes.

### `data`

Contains additional information about the error, does not have any specific format.

## Codes

### Products

 * **1000:** Product missing
 
### Cart

 * **2000:** This product is currently out of stock.
 * **2001:** The requested quantity is not available.
 * **2002:** Pleace specify a product option.
 * **2003:** Unable to add item to cart.
 * **2004:** Please specify a product and quantity.
 * **2005:** Please specify a product.
 * **2006:** Product could not be found.
 * **2007:** A product coult not be found in the cart.
 * **2008:** Unable to add item to cart.
 * **2009:** Product could not be found.

### Checkout

 * **4000:** Payment method value must be a string.
 * **4002:** Delivery method value must be a string.
 * **4003:** Faulty delivery method
 * **4004:** Could not find cart
 * **4005:** The specified address contains an error.
 * **4006:** The specified address could not be verified.
 * **4007:** An error occured.
 * **4008:** Your cart is empty.
 * **4009:** Delivery address could not be verified.
 * **4010:** Please specify a delivery method.
 * **4011:** Invoicing address could not be verified.
 * **4012:** Please specify a payment method.
 * **4013:** We are experiencing issues with the requested payment method. Please try another one.
 * **4014:** Could not verify payment data.
 * **4015:** An error occurred.

### Dibs

 * **6000:** Order number missing.
 * **6001:** Could not verify cart payment data from payment gateway.
 * **6002:** Order not found.
