<?php

class Crossroads_API_Helper_Category {
    protected $_imageKeys = [
        "small"  => "cls_catfields_general_img_s",
        "medium" => "cls_catfields_general_img_m",
        "large"  => "cls_catfields_general_img_l"
    ];

    protected function getTempImages($images) {
        if(empty($images)) {
            return [];
        }

        $db  = Mage::getSingleton('core/resource')->getConnection('core_read');

        $sql = "SELECT `name`, `data` FROM `crossroads_categoryimagecache`
                WHERE name IN (" . implode(",", array_fill(0, count($images), "?")) . ")";

        return $db->query($sql, array_values($images))->fetchAll(Zend_Db::FETCH_ASSOC);
    }

    protected static function getImageData($images, $key) {
        if (!$images) {
            return null;
        }
        foreach($images as $d) {
            if($d["name"] === $key) {
                return $d["data"];
            }
        }

        return null;
    }

    /**
     * Retrieves category images map with keys being the image type and value being a map
     * with url being absolute url to the image and dataUrl being a dataUrl which can be
     * used as a placeholder.
     *
     * @return Associative array
     */
    protected function getCategoryImages($category) {
        $imageNames = array_filter(array_map(function($k) use($category) {
            return $category->getData($k);
        }, $this->_imageKeys));

        $tempImages = $this->getTempImages($imageNames);

        return array_map(function($name) use($tempImages) {
            return [
                "url"     => Mage::getBaseUrl("media")."catalog/category/".$name,
                "dataUrl" => self::getImageData($tempImages, $name),
            ];
        }, $imageNames);
    }

    /**
     * Prepares a category, returning data suitable for JSON-encoding.
     *
     * @param  Category
     * @param  Set to true to include images in the category
     * @return Array Associative array
     */
    public function prepareCategory($category, $includeImages)
    {
        $data   = $category->getData();
        // Use stdClass to enforce object if empty
        $images = $includeImages ? $this->getCategoryImages($category) : new stdClass();

        return [
            "id"              => (int)$data["entity_id"],
            "name"            => $data["name"],
            "description"     => $data["description"],
            "metaDescription" => $data["meta_description"],
            "urlKey"          => $data["url_key"],
            "images"          => $images,
            "position"        => (int)$data["position"],
            "level"           => (int)$data["level"],
            "isAnchor"        => $data["is_anchor"] > 0,
            "path"            => $data["path"],
            "parentId"        => (int)$data["parent_id"],
            "metaTitle"       => $data["meta_title"],
            "includeInMenu"   => $data["include_in_menu"] > 0,
            "hero"            => [
                "heading"     => $category->getClsCatfieldsHeroHeading(),
                "description" => $category->getClsCatfieldsHeroDesc(),
                "offerIcon"   => $category->getClsCatfieldsHeroPercentage(),
                "modifier"    => $category->getClsCatfieldsHeroModifier(),
                "button" => [
                    "text" => $category->getClsCatfieldsHeroCtaText(),
                    "link" => $category->getClsCatfieldsHeroLink()
                ]
            ]
        ];
    }
}