<?php

class Crossroads_API_CouponController extends Crossroads_API_Controller_Resource
{
    public function getItem($id)
    {
        return [404];
    }

    /**
     * @api {get} /coupon Get active coupon code
     * @apiName getCouponCode
     * @apiGroup Coupon
     *
     * @apiSuccess {String} couponCode  The active coupon code
     * @apiSuccess {String} ruleName  The active rule name
     */
    public function getAll()
    {
        $data = Mage::helper("API/cart")->getCouponData();

        if(!$data) {
            $data = [
                "couponCode" => null,
                "ruleName"   => null
            ];
        }

        return [200, $data];
    }

    /**
     * @api {put} /coupon Add coupon code
     * @apiHeader {String} Content-Type application/json
     * @apiName addCouponCode
     * @apiDescription You will need at least one product in cart
     * @apiGroup Coupon
     *
     * @apiParam {String} couponCode  The coupon code
     *
     * @apiSuccess {String} couponCode  The active coupon code
     * @apiSuccess {String} ruleName  The active rule name
     * @apiError (403) Faulty coupon code.
     */
    public function replaceAll()
    {
        $params = $this->requestData();
        $coupon_code = $params["couponCode"];
        $quote = Mage::getSingleton("checkout/cart")->getQuote();

        $quote->getShippingAddress()->setCollectShippingRates(true)->collectShippingRates();

        $quote
            ->setCouponCode($coupon_code)
            ->setTotalsCollectedFlag(false)
            ->collectTotals()->save();

        $quote->save(); // Now, save the whole quote

        $coupon = $quote->getCouponCode();

        if (!$coupon) {
            return [403];
        }

        return $this->getAll();
    }

    /**
     * @api {delete} /coupon Clear coupon code
     * @apiName clearCouponCode
     * @apiGroup Coupon
     *
     * @apiSuccess {String} couponCode  The active coupon code
     * @apiSuccess {String} ruleName  The active rule name
     */
    public function deleteAll()
    {
        $quote = Mage::getSingleton("checkout/cart")->getQuote();

        $quote->setCouponCode(null)
            ->collectTotals()
            ->save();

        return $this->getAll();
    }

}
