<?php

/**
 * Base controller for REST plural resources.
 */
abstract class Crossroads_API_Controller_Resource extends Crossroads_API_Controller_Super
{
    /**
     * List all items in this resource, applying filters from the request, reached using `GET /resource`.
     */
    public abstract function getAll();

    /**
     * Displays a single item from the resource, reached using `GET /resource/:id`.
     */
    public abstract function getItem($id);

    /**
     * Replaces all items in this resource with the supplied data from the client,
     * reached using `PUT /resource`.
     */
    public function replaceAll() {
        return [405];
    }

    /**
     * Empties this resource, reached using `DELETE /resource`.
     */
    public function deleteAll() {
        return [405];
    }

    /**
     * Adds an item to the resource, reached using `POST /resource`.
     */
    public function createItem() {
        return [405];
    }

    /**
     * Updates an item in the collection by replacing its data, reached using `PUT /resource/:id`.
     */
    public function replaceItem($id) {
        return [405];
    }

    /**
     * Updates an item in the collection by merging its data, reached using `PATCH /resource/:id`.
     */
    public function updateItem($id) {
        return [405];
    }

    /**
     * Deletes an item in the collection, reached using `DELETE /resource/:id`.
     */
    public function deleteItem($id) {
        return [405];
    }

    // Override base action
    public function indexAction() {
        try {
            switch($this->getRequest()->getMethod()) {
                case "GET":
                    return $this->sendData($this->getAll());
                case "POST":
                    return $this->sendData($this->createItem());
                case "PUT":
                    return $this->sendData($this->replaceAll());
                case "DELETE":
                    return $this->sendData($this->deleteAll());
                default:
                    return $this->sendData([405]);
            }
        }
        catch(Exception $e) {
            return $this->handleException($e);
        }
    }

    // Using true here we tell Magento's router that we support all actions.
    public function hasAction($_action) { return true; }

    // Catch all for all items in this resource
    public function norouteAction($_coreRoute = null) {
        $request = $this->getRequest();
        $uri     = trim($request->getRequestUri(), "/");
        $segment = strrchr($uri, "/");

        if(strlen($segment) === 0) {
            return $this->indexAction();
        }

        $id = substr($segment, 1);

        try {
            switch($request->getMethod()) {
                case "GET":
                    return $this->sendData($this->getItem($id));
                case "PUT":
                    return $this->sendData($this->replaceItem($id));
                case "PATCH":
                    return $this->sendData($this->updateItem($id));
                case "DELETE":
                    return $this->sendData($this->deleteItem($id));
                default:
                    // POST is nonsensical on singular resources
                    return $this->sendData([405]);
            }
        }
        catch(Exception $e) {
            return $this->handleException($e);
        }
    }
}
