# Crossroads API module

A generic API module for Magento, provides a RESTful API.

[API Documentation](https://magento6.crossroads.se/doc/)

## Requirements

* [Composer](https://getcomposer.org/download/)
* [Dibspw-module](http://groot.crossroads.se/modules/Dibspw-Official) (Optional‚ required for Dibs payment support)

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"Crossroads_API": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/Crossroads-API.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## Development

When this module is installed in a project Composer clones the git reposiotry into `vendor/Crossroads_API`. It will then create hard-links according to the `extra.map` specification inside of `composer.json` of the `Crossroads_API` package.

To modify and develop the `Crossroads_API` module, modify files inside of `vendor/Crossroads_API` instead of `app/code/local/Crossroads/API`. Then commit and push like normal inside of `vendor/Crossroads_API`.

### Documentation

Documentation can be built using [`node.js`](https://nodejs.org/en/download/):

```
npm install
npm run doc
```

This will result in a `doc` directory in the project root with the API documentation.

## Configuration

Magento needs to allow symlinked templates if Composer is installing modules through symlinks
(this is the default, see [magento-composer-installer Deploy documentation](https://github.com/Cotya/magento-composer-installer/blob/3.0/doc/Deploy.md)).
In Magento Admin set `System` -> `Configuration` -> `Advanced` -> `Developer` -> `Template Settings`
-> `Allow Symlinks` to Yes.

To correctly display prices in the returned data, configure the following settings to the
displayed values in Magento Admin -> System -> Configuration -> Sales -> Tax:

### Price Display Settings:

  **Display Product Prices In Catalog:** Including and Excluding Tax

  **Display Shipping Prices:** Including and Excluding Tax

### Shopping Cart Display Settings *and* Orders, Invoices, Credit Memos Display Settings

  **Display Prices:** Including and Excluding Tax

  **Display Subtotal:** Including and Excluding Tax

  **Display Shipping Amount:** Including and Excluding Tax

  **Display Full Tax Summary:** Yes

  **Display Zero Tax Subtotal:** Yes

## Troubleshooting

* Some files got messed up and a reinstall of the module is required:

  ```
  composer run-script post-install-cmd -vvv -- --redeploy
  ```
