<?php
/**
 * @copyright   Copyright (c) 2009-14 Amasty
 */
class Amasty_Rules_Model_SalesRule_Rule_Condition_Product_Combine extends Mage_SalesRule_Model_Rule_Condition_Product_Combine
{
    public function validate(Varien_Object $object)
    {
        // for optimization if we no conditions
        if (!$this->getConditions()) {
            return true;
        }

        $origProduct  = null;
        if ($object->getHasChildren() && $object->getProductType() == 'configurable'){
            //remember original product
            $origProduct = $object->getProduct();
            $origSku     = $object->getSku();

            foreach ($object->getChildren() as $child) {
                // only one itereation.
                $categoryIds = array_unique(array_merge($child->getProduct()->getCategoryIds(), $origProduct->getCategoryIds()));

                $object->setProduct($child->getProduct());
                $object->setSku($child->getSku());
                $object->getProduct()->setCategoryIds($categoryIds);
            }
        }

        // Mage_Rule_Model_Condition_Combine::validate
        $result = $this->combineValidate($object);

        if ($origProduct){
            // restore original product
            $object->setProduct($origProduct);
            $object->setSku($origSku);
        }

        return $result;
    }

    /**
     * Copy of Mage_Rule_Model_Condition_Combine::validate
     *
     * Added by Martin Wernstål
     *
     * This is to prevent the madness which is multiple inheritance using static calls on non-static methods.
     *
     * @param  Varien_Object
     * @return boolean
     */
    public function combineValidate(Varien_Object $object)
    {
        if (!$this->getConditions()) {
            return true;
        }

        $all  = $this->getAggregator() === 'all';
        $true = (bool)$this->getValue();

        foreach ($this->getConditions() as $cond) {
            $validated = $cond->validate($object);

            if ($all && $validated !== $true) {
                return false;
            } elseif (!$all && $validated === $true) {
                return true;
            }
        }

        return $all ? true : false;
    }
}
