# Awardit Advent Calendar module

This module allows an admin to map a set of categories to a set of dates, only returning the category that matches the specific date.

## Requirements

* [Composer](https://getcomposer.org/download/)

## Installation
1. Add composer.crossroads.se to your repositories
2. Run `composer require crossroads/adventcalendar`

## Usage

### Configuration
The configuration is based on the following json keys:
```json
{
	"1201": {
    "category_id": "581", // Maps to a category id in the specific store
		"variant": "overlay" // Allows you to specify variants that gets passed to the frontend
	}
}
```
### Usage
Doors are queried in graphQL like so:

```gql
query {
  adventCalendar(
    testdate: "2020-12-02"
    password: "foo"
  ) {
		...on AdventCalendarDoorOpen {
      day
      variant
      category {
        products {
          items {
            name
          }
        }
      }
    }
  }
}
```