<?php

class Crossroads_AdventCalendar_Helper_Data extends Mage_Core_Helper_Abstract
{
    const CONFIG_IS_ENABLED = "AdventCalendar/general/activated";
    const CONFIG_DATA = "AdventCalendar/general/data";
    const CONFIG_PASSWORD = "AdventCalendar/settings/password";
    const CONFIG_START_DATE = "AdventCalendar/settings/start_date";
    const CONFIG_END_DATE = "AdventCalendar/settings/end_date";
    const CONFIG_TIME = "AdventCalendar/settings/time";

    public function isEnabled(Mage_Core_Model_Store $store): bool {
       return (bool)$store->getConfig(self::CONFIG_IS_ENABLED);
    }

    public function getStartDate(Mage_Core_Model_Store $store): string {
       return (string)$store->getConfig(self::CONFIG_START_DATE);
    }

    public function getEndDate(Mage_Core_Model_Store $store): string {
       return (string)$store->getConfig(self::CONFIG_END_DATE);
    }

    public function getTime(Mage_Core_Model_Store $store): string {
       return (string)$store->getConfig(self::CONFIG_TIME);
    }

    public function getPassword(Mage_Core_Model_Store $store): string {
       return (string)$store->getConfig(self::CONFIG_PASSWORD);
    }

    /**
     * @return array<string, array{category_id: string}>
     */
    public function getConfigData(Mage_Core_Model_Store $store): array {
        $config = (string) $store->getConfig(self::CONFIG_DATA);
        $data = json_decode($config, true);

        if ($data === null) {
            throw new Exception(sprintf("%s: Failed to read JSON: %s", __METHOD__, json_last_error_msg()));
        }

        return $data;
    }

    /**
     * @return Array<int>
     */
    public function getDoorIds(Mage_Core_Model_Store $store) {
        $doorData = $this->getConfigData($store);

        return array_map(function($door) {
            return (int)$door["category_id"];
        },$doorData);
    }

    /**
     * @return array<string|int>
     */
    public function getConfigDayById(Mage_Core_Model_Store $store, int $id): array {
        $config = $this->getConfigData($store);

        foreach($config as $key => $door) {
            if ((int)$door["category_id"] === $id) {
                $day = (int)substr($key, 2);
                return array_merge($door, ["day" => $day]);
            }
        }

        throw new Error("Couldn't find category_id $id in json config");
    }

    /**
     * @return Array<int>
     */
    public function getOpenIds(Mage_Core_Model_Store $store, int $now): array {
        $doorData = $this->getConfigData($store);
        $startDateConfig = $this->getStartDate($store);
        $endDateConfig = $this->getEndDate($store);
        $time = $this->getTime($store);

        $categoryIds = [];
        $current_month = date("m", $now);
        $current_day = date("d", $now);

        $switchTime = empty($time) ? "00:00:00" : $time;

        $startDate = strtotime(
            (empty($startDateConfig) ?
                date("Y", $now)."-12-01" :
                $startDateConfig) . " " . $switchTime);

        $endDate = strtotime(
            (empty($endDateConfig) ?
                (date("Y", $now) + 1)."-01-15" :
                $endDateConfig) . " " . $switchTime);

        // Return no categories if before or past christmas
        if ($now < $startDate || $now > $endDate) {
            return [-1];
        }

        foreach ($doorData as $day => $door) {
            if ($current_month . $current_day >= $day) {
                array_push($categoryIds, (int)$door["category_id"]);
            }
        }

        return $categoryIds;
    }
}
