<?php

class Crossroads_AdventCalendar_Helper_Data extends Mage_Core_Helper_Abstract
{
    public function getConfig()
    {
        if(empty($this->_config)) {
            return Mage::getStoreConfig('AdventCalendar', Mage::app()->getStore()->getId());
        }
        return null;
    }

    public function getHatches($now, $req)
    {
        $config        = $this->getConfig();
        $doorData      = json_decode($config['general']['data'], true);
        $settings      = $config['settings'];
        $current_month = date('m', $now);
        $current_day   = date('d', $now);

        $switchTime = empty($settings['time']) ? '00:00:00' : $settings['time'];

        $startDate = strtotime(
            (empty($config['settings']['start_date']) ?
            date('Y', $now).'-12-01' :
            $config['settings']['start_date'])
            . ' ' . $switchTime
        );

        $endDate = strtotime(
            (empty($settings['end_date']) ?
            (date('Y', $now) + 1).'-01-15' :
            $settings['end_date'])
            . ' ' . $switchTime
        );
        
        if ($now < $startDate || $now > $endDate) {
            return [];
        }

        if (!$doorData) {
            return [500, 'invalid calendar data: ' . json_last_error()];
        }

        $categories = [];
        foreach ($doorData as $day => $door) {
            if ($current_month . $current_day == $day) {
                $categories[$door["category_id"]] = 0;
            } elseif ($current_month . $current_day > $day) {
                $categories[$door["category_id"]] = 1;
            }
        }

        $store    = Mage::app()->getStore();
        $factory  = Mage::getModel("API/factory");
        $prodSer  = $factory->createProductListSerializer($store);
        $catSer   = $factory->createCategorySerializer($store, true);

        $categoryIds = [];
        foreach ($doorData as $day => $door) {
            if ($current_month . $current_day > $day) {
                $categoryId = intval($door["category_id"]);
                if (!empty($categoryId)) {
                    $categoryIds[] = $categoryId;
                }
            }
        }

        $doors = [];
        foreach ($doorData as $day => $door) {
            if ($current_month . $current_day == $day) {
                $category = Mage::getModel('catalog/category')->load($door["category_id"]);
                $collection = Mage::getModel("API/collection_product_category")
                    ->setStore($store)
                    ->setCategory($category)
                    ->setPage($req->getQuery("page"))
                    ->setLimit($req->getQuery("limit"))
                    ->createCollection();
                $doors[] = [
                    "day" => $day,
                    "category"  => $catSer->serializeItem($category),
                    "products" => $prodSer->mapCollection($collection),
                    "open" => true
                ];
            } elseif ($current_month . $current_day > $day) {
                $category = Mage::getModel('catalog/category')->load($door["category_id"]);
                $doors[] = [
                    "day" => $day,
                    "category"  => $catSer->serializeItem($category),
                    "products" => $prodSer->mapArray($this->getFirstProductInCategory($store, $category)),
                    "open" => true
                ];
            } else {
                $doors[] = [
                    "day"  => $day,
                    "category"  => new Stdclass(),
                    "products" => [],
                    "open" => false
                ];
            }
        }

        return $doors;
    }

    public function getFirstProductInCategory($store, $category)
    {
        $collection = Mage::getModel("API/collection_product_category")
            ->setStore($store)
            ->setCategory($category)
            //->addAttributeToSort('position', 'ASC')
            ->createCollection();
        $collection->getSelect()->limit(1);

        return [$collection->getFirstItem()];
    }
}
