<?php

class Crossroads_AdventCalendar_AdventCalendarController extends Crossroads_API_Controller_Resource {

    /**
     * @api {get} /api/adventcalendar  Get all doors
     * @apiName getAllDoors
     * @apiGroup AdventCalendar
     *
     * @apiSuccess {Object[]} Array of doors (opened and closed)
     */
    public function getAll() {
        $now = time();

        if(!empty($_GET['testdate'])) {
            $now = strtotime("{$_GET['testdate']} 17:01:00");
        }
        if(!empty($_GET['testday'])) {
            $param = $_GET['testday'];
            $month = substr($param, 0, 2);
            $day = substr($param, 2, 2);
            $now = strtotime(date('Y')."-{$month}-{$day} 17:01:00");
        }

        $doors = Mage::helper('Crossroads_AdventCalendar')->getHatches($now);

        return [200, $doors];
    }

    public function getItem($id) {
        return [404];
    }
}
