<?php

class Crossroads_AdventCalendar_Helper_Data extends Mage_Core_Helper_Abstract
{
    public function getConfig()
    {
        if(empty($this->_config)) {
            return Mage::getStoreConfig('AdventCalendar', Mage::app()->getStore()->getId());
        }
        return null;
    }

    public function getHatches($now)
    {
        $config        = $this->getConfig();
        $doorData      = json_decode($config['general']['data'], true);
        $settings      = $config['settings'];
        $current_month = date('m', $now);
        $current_day   = date('d', $now);

        $switchTime = empty($settings['time']) ? '00:00:00' : $settings['time'];

        $startDate = strtotime(
            (empty($config['settings']['start_date']) ?
            date('Y', $now).'-12-01' :
            $config['settings']['start_date'])
            . ' ' . $switchTime
        );

        $endDate = strtotime(
            (empty($settings['end_date']) ?
            (date('Y', $now) + 1).'-01-15' :
            $settings['end_date'])
            . ' ' . $switchTime
        );
        
        if ($now < $startDate || $now > $endDate) {
            return [];
        }

        if (!$doorData) {
            return [500, 'invalid calendar data: ' . json_last_error()];
        }

        $doors = [];

        foreach ($doorData as $day => $door) {
            if ($current_month . $current_day < $day ||
                $current_month . $current_day > $day + $settings['days_back'] - 1) {
                $doors[] = [
                    "day"  => $day,
                    "url"  => null,
                    "open" => false
                ];
            } else {
                $doors[] = [
                    "day" => $day,
                    "url" => $door['url'],
                    "open" => true
                ];
            }
        }

        return $doors;
    }
}
