<?php

class Awardit_Upsert_Model_Source_Upsert_Index extends Mage_Eav_Model_Entity_Attribute_Source_Abstract {

    const UPSERT_INDEX_ALL = 0;
    const UPSERT_INDEX_PARTNER_OWNED = 1;
    const UPSERT_INDEX_NONE = 2;

    public function getAllOptions(): array
    {
        if (!$this->_options) {
            $this->_options = [
                0 => [
                    "value" => self::UPSERT_INDEX_ALL,
                    "label" => "All",
                ],
                1 => [
                    "value" => self::UPSERT_INDEX_PARTNER_OWNED,
                    "label" => "Partner owned only",
                ],
                2 => [
                    "value" => self::UPSERT_INDEX_NONE,
                    "label" => "None",
                ],
            ];
        }

        return $this->_options;
    }

    public function toOptionArray(): array
    {
        $_options = [];
        if ($this->getAllOptions()) {
            foreach ($this->getAllOptions() as $option) {
                $_options[ $option["value"] ] = $option["label"];
            }
        }
        return $_options;
    }

}
