<?php

class Awardit_Upsert_Block_Adminhtml_AttributeSelect extends Mage_Core_Block_Html_Select
{
    private static $disallowed = [
        'sku',
        'name',
        'description',
        'short_description',
    ];

    /* @var $attributes array|null */
    private $attributes = null;

    /**
     * Retrieve email templates
     * @return array
     */
    protected function getAttributes(): array
    {
        if (is_null($this->attributes)) {
            $this->attributes = [];
            $collection = Mage::getSingleton('eav/config')
                ->getEntityType(Mage_Catalog_Model_Product::ENTITY)
                ->getAttributeCollection()
                ->addFieldToFilter('frontend_input', ['text', 'textarea'])
                ;
            foreach ($collection as $attribute) {
                /* @var Mage_Catalog_Model_Resource_Eav_Attribute $attribute */
                $code = $attribute->getData('attribute_code');
                $name = htmlspecialchars($attribute->getData('frontend_label'));
                $type = $attribute->getData('frontend_input');
                if (empty($name) || in_array($code, self::$disallowed)) {
                    continue;
                }
                $this->attributes[$code] = $name;
            }
            asort($this->attributes);
        }
        return $this->attributes;
    }

    /**
     * @param string $value
     * @return Awardit_ProductEmail_Block_Adminhtml_Form_Field_EmailTemplates
     */
    public function setInputName($value): Mage_Core_Block_Html_Select
    {
        return $this->setName($value);
    }

    /**
     * Render block HTML
     * @return string
     */
    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            foreach ($this->getAttributes() as $attribute_id => $attribute_label) {
                $this->addOption($attribute_id, addslashes($attribute_label));
            }
        }
        return parent::_toHtml();
    }
}
