<?php
$installer = $this;
$installer->startSetup();
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");

// Add product attribute awardit_target_id
$newAttributes = [
    "awardit_awaiting_price" => [
        "label" => "Awaiting price from API",
        "group" => "Awardit",
        "type" => "int",
        "input" => "boolean",
        "source" => "eav/entity_attribute_source_boolean",
        "required" => false,
        "visible_on_front" => false,
        "is_html_allowed_on_front" => true,
        "visible" => true,
        "used_in_product_listing" => true,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => 0,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_check_terms" => [
        "label" => "Check terms",
        "group" => "Awardit",
        "type" => "int",
        "input" => "boolean",
        "source" => "eav/entity_attribute_source_boolean",
        "required" => false,
        "visible_on_front" => true,
        "is_html_allowed_on_front" => true,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => false,
        "default" => 0,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_image_hash" => [
        "label" => "Image hash",
        "group" => "Awardit",
        "type" => "varchar",
        "input" => "text",
        "required" => false,
        "visible_on_front" => false,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_invoice_name" => [
        "label" => "Name for Awardit invoice",
        "group" => "Awardit",
        "type" => "varchar",
        "input" => "text",
        "required" => false,
        "visible_on_front" => false,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_options_hash" => [
        "label" => "Options hash",
        "group" => "Awardit",
        "type" => "varchar",
        "input" => "text",
        "required" => false,
        "visible_on_front" => false,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_partner_owned" => [
        "label" => "Partner owned product",
        "group" => "Awardit",
        "type" => "int",
        "input" => "boolean",
        "source" => "eav/entity_attribute_source_boolean",
        "required" => false,
        "visible_on_front" => false,
        "is_html_allowed_on_front" => true,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => 0,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_points" => [
        "label" => "Awardit points",
        "group" => "Awardit",
        "type" => "varchar",
        "input" => "text",
        "required" => false,
        "visible_on_front" => false,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "frontend_class" => "validate-digits",
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_is_featured" => [
        "label" => "Featured product",
        "group" => "Awardit",
        "type" => "int",
        "input" => "boolean",
        "source" => "eav/entity_attribute_source_boolean",
        "required" => false,
        "visible_on_front" => true,
        "is_html_allowed_on_front" => "1",
        "is_filterable_in_search" => "1",
        "visible" => true,
        "used_in_product_listing" => true,
        "filterable" => true,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => 0,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_terms" => [
        "label" => "Terms",
        "group" => "Awardit",
        "type" => "text",
        "input" => "textarea",
        "required" => false,
        "visible_on_front" => true,
        "is_html_allowed_on_front" => "1",
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => false,
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_valid_from" => [
        "label" => "Valid from",
        "group" => "Awardit",
        "type" => "varchar",
        "input" => "date",
        "required" => false,
        "visible_on_front" => false,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
    "awardit_valid_to" => [
        "label" => "Valid to",
        "group" => "Awardit",
        "type" => "varchar",
        "input" => "date",
        "required" => false,
        "visible_on_front" => false,
        "visible" => true,
        "used_in_product_listing" => false,
        "filterable" => false,
        "searchable" => false,
        "comparable" => false,
        "user_defined" => true,
        "default" => null,
        "is_configurable" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "position" => 0,
    ],
];

// Add all new attributes
foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add attribute
        // if attribute value 'group' is not empy OR attribute value 'user_defined' is empty (false), then new attribute is automatically added to all attribute sets
        // and then if attribute value 'group' is not empy, attribute is added to speciefied attribute group, otherwise it is added to the default attribute group.
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

    }
}

$eavConfig = Mage::getSingleton('eav/config');

// Customer attributes to update
$attributes = [
    "dob",
    "gender"
];

foreach ($attributes as $attribute) {
    /** @var Mage_Customer_Model_Attribute $attribute */
    $attribute = $eavConfig->getAttribute('customer', $attribute);
    $attribute->setData('is_visible', true);
    $attribute->save();
}

$installer->endSetup();
