<?php
$installer = $this;
$installer->startSetup();
$setup = Mage::getResourceModel("catalog/setup", "catalog_setup");

// Add product attribute awardit_target_id
$newAttributes = [
    "awardit_target_id" => [
        "label" => "Target Id",
        "group" => "Awardit",
        "sort_order" => 100,
        "backend" => "",
        "type" => "int",
        "frontend" => "",
        "note" => "",
        "default" => 0,
        "wysiwyg_enabled" => false,
        "input" => "text",
        "input_renderer" => "",
        "source" => "",
        "required" => false,
        "user_defined" => false,
        "unique" => false,
        "global" => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        "visible" => true,
        "visible_on_front" => true,
        "used_in_product_listing" => true,
        "searchable" => false,
        "visible_in_advanced_search" => false,
        "filterable" => false,
        "filterable_in_search" => false,
        "comparable" => false,
        "is_html_allowed_on_front" => false,
        "apply_to" => "simple,virtual",
        "is_configurable" => false,
        "used_for_sort_by" => false,
        "position" => 0,
        "used_for_promo_rules" => false,
    ],
];

// Add all new attributes
foreach ($newAttributes as $attributeName => $attributeData) {

    // Check if attribute already exists
    if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

        // Add attribute
        // if attribute value 'group' is not empy OR attribute value 'user_defined' is empty (false), then new attribute is automatically added to all attribute sets
        // and then if attribute value 'group' is not empy, attribute is added to speciefied attribute group, otherwise it is added to the default attribute group.
        $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

    }
}

$installer->endSetup();
