<?php

class Awardit_Upsert_Helper_Data extends Awardit_Integration_Helper_Data {

    const DEFAULT_LOG_FILENAME = "awardit_upsert.log";

    public function log($message, $logType = LOG_DEBUG, $filename = self::DEFAULT_LOG_FILENAME)
    {
        parent::log($message, $logType, $filename);
    }

    public function isSavedByAdmin()
    {
        if (!Mage::app()->getStore()->isAdmin()) {
            return false;
        }

        if (Mage::getDesign()->getArea() != "adminhtml") {
            return false;
        }

        if (empty($_POST["form_key"])) {
            return false;
        }

        if (empty($_POST["product"]["points_prices"])) {
            return false;
        }

        return true;
    }

    public function getStoresEnabledForTimedPrices()
    {
        $sqlQuery = "
            SELECT
                tmp.store_id,
                tmp.config_value
            FROM (
                SELECT
                    cs.store_id,
                    COALESCE(
                        ( SELECT core_config_data.`value` FROM core_config_data WHERE core_config_data.path = 'integration/upsert/process_timed_prices' AND core_config_data.scope = 'stores' AND core_config_data.scope_id = cs.store_id ),
                        ( SELECT core_config_data.`value` FROM core_config_data WHERE core_config_data.path = 'integration/upsert/process_timed_prices' AND core_config_data.scope = 'websites' AND core_config_data.scope_id = cs.website_id ),
                        ( SELECT core_config_data.`value` FROM core_config_data WHERE core_config_data.path = 'integration/upsert/process_timed_prices' AND core_config_data.scope = 'default' AND core_config_data.scope_id = 0 ),
                        0
                    ) AS config_value
                FROM core_store cs
                ORDER BY cs.store_id
            ) tmp
            WHERE tmp.config_value = 1
        ";
        return Mage::getSingleton("core/resource")->getConnection("core_read")->fetchAssoc($sqlQuery);
    }

    public function getProductsWithTimedPricesByStore($store)
    {
        $sqlQuery = "
            SELECT
                *
            FROM (
                SELECT
                    cpe.entity_id,
                    (
                        SELECT
                            COALESCE(
                                MAX(IF(catalog_product_entity_varchar.store_id = cs.store_id, catalog_product_entity_varchar.`value`, NULL)),
                                MAX(IF(catalog_product_entity_varchar.store_id = 0, catalog_product_entity_varchar.`value`, NULL))
                            )
                        FROM catalog_product_entity_varchar
                        JOIN eav_attribute ON eav_attribute.attribute_id = catalog_product_entity_varchar.attribute_id
                        WHERE catalog_product_entity_varchar.entity_id = cpe.entity_id AND eav_attribute.attribute_code = 'awardit_valid_from' AND (catalog_product_entity_varchar.store_id = 0 OR catalog_product_entity_varchar.store_id = cs.store_id)
                        GROUP BY catalog_product_entity_varchar.entity_id
                    ) AS awardit_valid_from,
                    (
                        SELECT
                            COALESCE(
                                MAX(IF(catalog_product_entity_varchar.store_id = cs.store_id, catalog_product_entity_varchar.`value`, NULL)),
                                MAX(IF(catalog_product_entity_varchar.store_id = 0, catalog_product_entity_varchar.`value`, NULL))
                            )
                        FROM catalog_product_entity_varchar
                        JOIN eav_attribute ON eav_attribute.attribute_id = catalog_product_entity_varchar.attribute_id
                        WHERE catalog_product_entity_varchar.entity_id = cpe.entity_id AND eav_attribute.attribute_code = 'awardit_valid_to' AND (catalog_product_entity_varchar.store_id = 0 OR catalog_product_entity_varchar.store_id = cs.store_id)
                        GROUP BY catalog_product_entity_varchar.entity_id
                    ) AS awardit_valid_to,
                    (
                        SELECT
                            COALESCE(
                                MAX(IF(catalog_product_entity_int.store_id = cs.store_id, catalog_product_entity_int.`value`, NULL)),
                                MAX(IF(catalog_product_entity_int.store_id = 0, catalog_product_entity_int.`value`, NULL))
                            )
                        FROM catalog_product_entity_int
                        JOIN eav_attribute ON eav_attribute.attribute_id = catalog_product_entity_int.attribute_id
                        WHERE catalog_product_entity_int.entity_id = cpe.entity_id AND eav_attribute.attribute_code = 'status' AND (catalog_product_entity_int.store_id = 0 OR catalog_product_entity_int.store_id = cs.store_id)
                        GROUP BY catalog_product_entity_int.entity_id
                    ) AS `status`
                FROM catalog_product_entity cpe
                JOIN catalog_product_website cpw ON cpw.product_id = cpe.entity_id
                JOIN core_store cs ON cs.website_id = cpw.website_id
                WHERE cs.store_id = :storeId AND cpe.type_id IN ('simple','virtual')
            ) t
            WHERE (t.awardit_valid_from IS NOT NULL OR t.awardit_valid_to IS NOT NULL)
        ";
        $params = [
            "storeId" => $store->getId()
        ];
        return Mage::getSingleton("core/resource")->getConnection("core_read")->fetchAll($sqlQuery, $params);

    }

    public function activateProductsWithTimedPricesInStore($store)
    {
        $collection = $this->getProductsWithTimedPricesByStore($store);
        foreach ($collection as $product) {
            if (empty($product["awardit_valid_from"]) || $product["status"] == Mage_Catalog_Model_Product_Status::STATUS_ENABLED) {
                continue;
            }

            $validFrom = new DateTime($product["awardit_valid_from"]); // Y-m-d 00:00:00
            $now = new DateTime(date("Y-m-d 00:00:00", strtotime("tomorrow")));

            if ($now >= $validFrom) {
                // Activate product
                $localProduct = Mage::getModel("catalog/product")->setStoreId($store->getId())->load($product["entity_id"]);
                $localProduct->setStatus(Mage_Catalog_Model_Product_Status::STATUS_ENABLED);
                $localProduct->save();
            }
        }
    }

    public function deactivateProductsWithTimedPricesInStore($store)
    {
        $collection = $this->getProductsWithTimedPricesByStore($store);
        foreach ($collection as $product) {
            if (empty($product["awardit_valid_to"]) || $product["status"] == Mage_Catalog_Model_Product_Status::STATUS_DISABLED) {
                continue;
            }

            $validTo = new DateTime($product["awardit_valid_to"]); // Y-m-d 00:00:00
            $now = new DateTime(date("Y-m-d 00:00:00", strtotime("yesterday")));

            if ($now >= $validTo) {
                // Deactivate product
                $localProduct = Mage::getModel("catalog/product")->setStoreId($store->getId())->load($product["entity_id"]);
                $localProduct->setStatus(Mage_Catalog_Model_Product_Status::STATUS_DISABLED);
                $localProduct->save();
            }
        }
    }

}
