<?php

class Awardit_Upsert_Model_Observer extends Mage_Core_Model_Abstract {

    public function saveProductEvent(Varien_Event_Observer $observer)
    {
        $product = $observer->getProduct();
        //$product = $observer->getEvent()->getProduct(); // Old way to get product?

        if (empty($product)) {
            return;
        }
        $storeId = $product->getStoreId();
        if (empty($storeId)) {
            return; // Only handle products in a store
        }

        // Check if product type is one we are supposed to process
        if (!in_array($product->getTypeId(), [ Mage_Catalog_Model_Product_Type::TYPE_VIRTUAL, Mage_Catalog_Model_Product_Type::TYPE_SIMPLE ])) {
            return;
        }

        // Check if we allow 0 points
        if (Mage::getStoreConfig("integration/upsert/allow_zero_points", $storeId)) {
            return;
        }

        // Check if we got called saving product in Admin
        if (!Mage::helper("awardit_upsert")->isSavedByAdmin()) {
            return;
        }

        $havePoints = false;
        $haveZeroPoints = false;

        /* $_POST[points_prices] => Array
         * (
         *     [0] => Array
         *     (
         *         [id] => NULL | n
         *         [type] => awardit
         *         [store_id] => n
         *         [customer_group_id] => 0
         * 1)      [use_default] => true
         * 2)      [price] => n
         * 2)      [min_price] => n
         * 2)      [max_price] => NULL
         *     )
         * )
         * Either 1) or 2) is present.
         */

        $pointsPrices = $product->getData("points_prices");
        if (!empty($pointsPrices)) {
            $havePoints = true;
            foreach($pointsPrices as $item) {
                if (!$item->getPrice()) {
                    $haveZeroPoints = true;
                    break;
                }
            }
        }

        // We must have at least one points price and they all must have points > 0 to return.
        if ($havePoints && !$haveZeroPoints) {
            return;
        }

        // Check status
        if ($product->getStatus() == Mage_Catalog_Model_Product_Status::STATUS_DISABLED) {
            return;
        }

        // Set status
        $product->setStatus(Mage_Catalog_Model_Product_Status::STATUS_DISABLED);

        // Add information about product becoming disabled
        Mage::getSingleton("adminhtml/session")->addError("Product is missing or having 0 points and is therefore being disabled in current store!");
    }

}
