<?php

class Awardit_Upsert_Block_Adminhtml_SkuMapping
    extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    /**
     * @var Awardit_Upsert_Block_Adminhtml_AttributeSelect|null
     */
    private $renderer = null;

    /**
     * Retrieve attributes
     * @return Awardit_Upsert_Block_Adminhtml_AttributeSelect
     */
    protected function getAttributes(): Awardit_Upsert_Block_Adminhtml_AttributeSelect
    {
        if (is_null($this->renderer)) {
            $this->renderer = $this->getLayout()->createBlock(
                'awardit_upsert/adminhtml_attributeSelect',
                '',
                ['is_render_to_js_template' => true]
            );
            $this->renderer->setClass('attribute_select');
            $this->renderer->setExtraParams('style="width:250px"');
        }
        return $this->renderer;
    }

    /**
     * Prepare to render
     */
    protected function _prepareToRender(): void
    {
        $helper = Mage::helper('awardit_upsert');
        $this->addColumn('sku', [
            'label' => $helper->__('SKU'),
            'style' => 'width:100px',
        ]);
        $this->addColumn('attribute_id', [
            'label' => $helper->__('Attribute'),
            'renderer' => $this->getAttributes(),
        ]);
        $this->addColumn('value', [
            'label' => $helper->__('Attribute value'),
            'style' => 'width:100px',
        ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = $helper->__('Add SKU matcher');
    }

    /**
     * Prepare existing row data object
     * @param Varien_Object $row
     */
    protected function _prepareArrayRow(Varien_Object $row): void
    {
        $row->setData(
            'option_extra_attr_' . $this->getAttributes()->calcOptionHash($row->getData('attribute_id')),
            'selected="selected"'
        );
    }
}
