<?php

$installer = $this;

$installer->startSetup();

$installer->run("
    CREATE TABLE `awardit_upsert_product` (
        `index_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
        `product_id` INT(10) UNSIGNED NOT NULL,
        `store_id` SMALLINT(5) UNSIGNED NOT NULL,
        `invoice_price` DECIMAL(12,4) UNSIGNED NULL DEFAULT NULL,
        `purchase_price` DECIMAL(12,4) UNSIGNED NULL DEFAULT NULL,
        `product_data` LONGTEXT NULL DEFAULT NULL COLLATE 'utf8mb4_unicode_ci',
        `created_at` TIMESTAMP NULL DEFAULT current_timestamp(),
        `updated_at` TIMESTAMP NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
        PRIMARY KEY (`index_id`) USING BTREE,
        INDEX `FK_awardit_upsert_product_catalog_product_entity` (`product_id`) USING BTREE,
        INDEX `FK_awardit_upsert_product_core_store` (`store_id`) USING BTREE,
	UNIQUE INDEX `IDX_awardit_upsert_product_product_id_store_id` (`product_id`, `store_id`) USING BTREE,
        CONSTRAINT `FK_awardit_upsert_product_catalog_product_entity` FOREIGN KEY (`product_id`)
            REFERENCES `catalog_product_entity` (`entity_id`) ON UPDATE CASCADE ON DELETE CASCADE,
        CONSTRAINT `FK_awardit_upsert_product_core_store` FOREIGN KEY (`store_id`)
            REFERENCES `core_store` (`store_id`) ON UPDATE CASCADE ON DELETE CASCADE,
        CONSTRAINT `product_data` CHECK (json_valid(`product_data`))
    )
    COLLATE='utf8mb4_unicode_ci'
    ENGINE=InnoDB
");

$installer->endSetup();
