<?php

class Awardit_Upsert_UpsertController extends Mage_Core_Controller_Front_Action {

    public function _construct()
    {
        parent::_construct();
    }

    // run by: /_auc/upsert/index
    public function indexAction()
    {
        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setBody("The End");
    }

    // run by: /_auc/upsert/product
    public function productAction()
    {
        try {
            // IP-lockdown?
            // $this->getHelper()->checkIP();
            $authorized = false;
            $model = Mage::getModel("awardit_upsert/api");

            if (!$model) {
                $this->getResponse()->setHttpResponseCode(500);
                $this->getResponse()->setBody("Missing model");
                return;
            }

            if (array_key_exists("HTTP_AUTHORIZATION", $_SERVER)) {
                if (!empty($_SERVER["HTTP_AUTHORIZATION"]) && strlen($_SERVER["HTTP_AUTHORIZATION"]) > 8) {
                    if (stripos($_SERVER["HTTP_AUTHORIZATION"], "Bearer ") === 0) {
                        $key = substr($_SERVER["HTTP_AUTHORIZATION"], 7);
                        $authorized = $model->isAuthorized($key);
                    }
                }
            }
            if (!$authorized) {
                $this->getResponse()->setHeader("WWW-Authenticate", 'Bearer realm=crossroads.se, charset="UTF-8"');
                $this->getResponse()->setHttpResponseCode(401);
                $this->getResponse()->setBody("Unauthorized");
                return;
            }

            $request = $this->getRequest();
            $method = $request->getMethod();
            if (empty($method)) {
                Mage::throwException("Missing method");
            }

            // $params = $request->getParams();
            $params = $model->getJsonBody($request);
            if (empty($params)) {
                $params = $request->getParams();
                if (empty($params)) {
                    Mage::throwException("Missing parameters");
                }
            }

            if (!empty($params["store_code"])) {
                $store = Mage::getConfig()->getNode("stores")->{$params["store_code"]};
                if (!empty($store)) {
                    $localStoreId = intval($store->{"system"}->{"store"}->{"id"});
                    if (!empty($localStoreId)) {
                        Mage::app()->setCurrentStore($localStoreId);
                    } else {
                        Mage::throwException("Unknown store code");
                    }
                } else {
                    Mage::throwException("Unknown store code");
                }
            }

            $matches = [];
            if (preg_match("/^.*product\/([^\/]+)[\/]?$/", $_SERVER["REQUEST_URI"], $matches) === 1) {
                $sku = $matches[1] ?? null;
            } else {
                $sku = $params["sku"] ?? null;
            }

            $localStore = Mage::app()->getStore();
            Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);

            $model->setLocalStore($localStore);
            switch (strtoupper($method)) {
                case "PUT":
                    if (empty($sku)) {
                        Mage::throwException("Missing sku!");
                        break;
                    }

                    Mage::log("PUT('{$sku}'): [{$localStore->getId()}] {$request->getRawBody()}", LOG_DEBUG, "api-request.log", true);
                    $result = $model->updateProductAction($params, $sku);
                    break;

                case "POST":
                    Mage::log("POST: [{$localStore->getId()}] {$request->getRawBody()}", LOG_DEBUG, "api-request.log", true);
                    $result = $model->createProductAction($params);
                    break;

                case "GET":
                    Mage::log("GET: [{$localStore->getId()}] " . json_encode($params), LOG_DEBUG, "api-request.log", true);
                    $result = $model->listProductsAction($params, $sku);
                    break;

                default:
                    Mage::throwException("Unhandeled method:{$method}");
                    break;
            }
        } catch (Exception $ex) {
            $this->getResponse()->setHttpResponseCode(400);
            $this->getResponse()->setHeader("Content-type", "application/json");
            $msg = ["message" => $ex->getMessage()];
            Mage::logException($ex);
            if (Mage::getIsDeveloperMode()) {
                $msg["trace"] = $ex->getTraceAsString();
            }
            $this->getResponse()->setBody(json_encode($msg, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
            return;
        }

        Mage::log("Response(200): " . json_encode($result, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES) . "\n", LOG_DEBUG, "api-request.log", true);
        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setHeader("Content-type", "application/json");
        $this->getResponse()->setBody(json_encode($result, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
    }

}
