<?php

class Awardit_Upsert_Model_Cli_ProductStatus extends Awardit_Integration_Model_Cli {

    protected $_defaultHelper = "integration/PointsCore";

    // -m=ProductStatus -f=activateSingleStore -p="storeId:<store-id>"
    public function CLI_activateSingleStore($param)
    {
        $this->setLimit(Awardit_Integration_Model_Cli_Cron::CRON_DEFAULT_ITERATION_LIMIT);

        $wantedParams = [
            "storeId" => "int"
        ];
        $extractedParams = $this->extractParams($param, $wantedParams);

        if (!empty($extractedParams["storeId"])) {
            $store = Mage::getModel('core/store')->load($extractedParams["storeId"]);
            if (!empty($store) && $store->getId() == $extractedParams["storeId"]) {
                $this->activateProductsInSingleStore($store);
            } else {
                Mage::helper($this->_defaultHelper)->log("Unknown store!", LOG_ERR);
                echo "Unknown store!\n";
            }
        } else {
            Mage::helper($this->_defaultHelper)->log("Missing parameter!", LOG_ERR);
            echo "Missing parameter!\n";
        }
    }

    // -m=ProductStatus -f=deactivateSingleStore -p="storeId:<store-id>"
    public function CLI_deactivateSingleStore($param)
    {
        $this->setLimit(Awardit_Integration_Model_Cli_Cron::CRON_DEFAULT_ITERATION_LIMIT);

        $wantedParams = [
            "storeId" => "int"
        ];
        $extractedParams = $this->extractParams($param, $wantedParams);

        if (!empty($extractedParams["storeId"])) {
            $store = Mage::getModel('core/store')->load($extractedParams["storeId"]);
            if (!empty($store) && $store->getId() == $extractedParams["storeId"]) {
                $this->deactivateProductsInSingleStore($store);
            } else {
                Mage::helper($this->_defaultHelper)->log("Unknown store!", LOG_ERR);
                echo "Unknown store!\n";
            }
        } else {
            Mage::helper($this->_defaultHelper)->log("Missing parameter!", LOG_ERR);
            echo "Missing parameter!\n";
        }
    }

    public function getProductsToProcessByStore($store)
    {
        $sqlQuery = "
            SELECT
                *
            FROM (
                SELECT
                    cpe.entity_id,
                    (
                        SELECT
                            COALESCE(
                                MAX(IF(catalog_product_entity_varchar.store_id = cs.store_id, catalog_product_entity_varchar.`value`, NULL)),
                                MAX(IF(catalog_product_entity_varchar.store_id = 0, catalog_product_entity_varchar.`value`, NULL))
                            )
                        FROM catalog_product_entity_varchar
                        JOIN eav_attribute ON eav_attribute.attribute_id = catalog_product_entity_varchar.attribute_id
                        WHERE catalog_product_entity_varchar.entity_id = cpe.entity_id AND eav_attribute.attribute_code = 'awardit_valid_from' AND (catalog_product_entity_varchar.store_id = 0 OR catalog_product_entity_varchar.store_id = cs.store_id)
                        GROUP BY catalog_product_entity_varchar.entity_id
                    ) AS awardit_valid_from,
                    (
                        SELECT
                            COALESCE(
                                MAX(IF(catalog_product_entity_varchar.store_id = cs.store_id, catalog_product_entity_varchar.`value`, NULL)),
                                MAX(IF(catalog_product_entity_varchar.store_id = 0, catalog_product_entity_varchar.`value`, NULL))
                            )
                        FROM catalog_product_entity_varchar
                        JOIN eav_attribute ON eav_attribute.attribute_id = catalog_product_entity_varchar.attribute_id
                        WHERE catalog_product_entity_varchar.entity_id = cpe.entity_id AND eav_attribute.attribute_code = 'awardit_valid_to' AND (catalog_product_entity_varchar.store_id = 0 OR catalog_product_entity_varchar.store_id = cs.store_id)
                        GROUP BY catalog_product_entity_varchar.entity_id
                    ) AS awardit_valid_to,
                    (
                        SELECT
                            COALESCE(
                                MAX(IF(catalog_product_entity_int.store_id = cs.store_id, catalog_product_entity_int.`value`, NULL)),
                                MAX(IF(catalog_product_entity_int.store_id = 0, catalog_product_entity_int.`value`, NULL))
                            )
                        FROM catalog_product_entity_int
                        JOIN eav_attribute ON eav_attribute.attribute_id = catalog_product_entity_int.attribute_id
                        WHERE catalog_product_entity_int.entity_id = cpe.entity_id AND eav_attribute.attribute_code = 'status' AND (catalog_product_entity_int.store_id = 0 OR catalog_product_entity_int.store_id = cs.store_id)
                        GROUP BY catalog_product_entity_int.entity_id
                    ) AS `status`
                FROM catalog_product_entity cpe
                JOIN catalog_product_website cpw ON cpw.product_id = cpe.entity_id
                JOIN core_store cs ON cs.website_id = cpw.website_id
                WHERE cs.store_id = :storeId AND cpe.type_id IN ('simple','virtual')
            ) t
            WHERE t.awardit_valid_from IS NOT NULL OR t.awardit_valid_to IS NOT NULL
        ";
        $params = [
            "storeId" => $store->getId()
        ];
        return Mage::getSingleton("core/resource")->getConnection("core_read")->fetchAll($sqlQuery, $params);
        
    }

    public function activateProductsInSingleStore($store)
    {
        $collection = $this->getProductsToProcessByStore($store);
        foreach ($collection as $product) {
            if (empty($product["awardit_valid_from"]) || $product["status"] == Mage_Catalog_Model_Product_Status::STATUS_ENABLED) {
                continue;
            }

            $validFrom = new DateTime($product["awardit_valid_from"]); // Y-m-d 00:00:00
            $now = new DateTime(date("Y-m-d 00:00:00", strtotime("tomorrow")));

            if ($now >= $validFrom) {
                // Activate product
                $localProduct = Mage::getModel("catalog/product")->setStoreId($store->getId())->load($product["entity_id"]);
                $localProduct->setStatus(Mage_Catalog_Model_Product_Status::STATUS_ENABLED);
                $localProduct->save();
            }
        }
    }

    public function deactivateProductsInSingleStore($store)
    {
        $collection = $this->getProductsToProcessByStore($store);
        foreach ($collection as $product) {
            if (empty($product["awardit_valid_to"]) || $product["status"] == Mage_Catalog_Model_Product_Status::STATUS_DISABLED) {
                continue;
            }

            $validTo = new DateTime($product["awardit_valid_to"]); // Y-m-d 00:00:00
            $now = new DateTime(date("Y-m-d 00:00:00", strtotime("yesterday")));

            if ($now >= $validTo) {
                // Deactivate product
                $localProduct = Mage::getModel("catalog/product")->setStoreId($store->getId())->load($product["entity_id"]);
                $localProduct->setStatus(Mage_Catalog_Model_Product_Status::STATUS_DISABLED);
                $localProduct->save();
            }
        }
    }

}
