<?php

class Awardit_Upsert_Model_Cli_ProductIndex extends Awardit_Integration_Model_Cli {

    protected $_defaultHelper = "integration/PointsCore";

    // -m=ProductIndex -f=indexAll
    public function CLI_indexAll($param): void
    {
        $resource = Mage::getResourceSingleton("awardit_upsert/product");

        $resource->indexAll();
    }

    // -m=ProductIndex -f=indexSingleStore -p="storeId:<store-id>"
    public function CLI_indexSingleStore($param): void
    {
        $resource = Mage::getResourceSingleton("awardit_upsert/product");

        $wantedParams = [
            "storeId" => "int"
        ];
        $extractedParams = $this->extractParams($param, $wantedParams);

        if (!empty($extractedParams["storeId"])) {
            $store = Mage::getModel('core/store')->load($extractedParams["storeId"]);
            if (!empty($store) && $store->getId() == $extractedParams["storeId"]) {
                $resource->indexSingleStore($store);
            } else {
                Mage::helper($this->_defaultHelper)->log("Unknown store!", LOG_ERR);
                echo "Unknown store!\n";
            }
        } else {
            Mage::helper($this->_defaultHelper)->log("Missing parameter!", LOG_ERR);
            echo "Missing parameter!\n";
        }
    }

    // -m=ProductIndex -f=indexSingleProduct -p="pId:<product_id>"
    public function CLI_indexSingleProduct($param): void
    {
        $resource = Mage::getResourceSingleton("awardit_upsert/product");

        $wantedParams = [
            "pId" => "int"
        ];
        $extractedParams = $this->extractParams($param, $wantedParams);

        if (!empty($extractedParams["pId"])) {
            $globalProduct = Mage::getModel("catalog/product")->setStoreId(0)->load($extractedParams["pId"]);
            if ($globalProduct && $globalProduct->getId() == $extractedParams["pId"]) {
                $resource->indexSingleProduct($globalProduct);
            }
        } else {
            Mage::helper($this->_defaultHelper)->log("Missing parameter!", LOG_ERR);
            echo "Missing parameter!\n";
        }
    }
}
