<?php

class Awardit_Upsert_UpsertController extends Mage_Core_Controller_Front_Action {

    /**
     * @return void
     */
    public function _construct()
    {
        parent::_construct();
    }

    /**
     * run by: /_auc/upsert/index
     *
     * @return void
     */
    public function indexAction()
    {
        $this->getResponse()->setHttpResponseCode(200);
        $this->getResponse()->setBody("The End");
    }

    /**
     * run by: /_auc/upsert/product
     *
     * @return void
     */
    public function productAction()
    {
        $localStore = Mage::app()->getStore();
        $request = $this->getRequest();
        $response = $this->getResponse();
        $skipBodyInLog = false;

        try {
            // IP-lockdown?
            // $this->getHelper()->checkIP();
            $authorized = false;
            $model = Mage::getModel("awardit_upsert/api");

            if (array_key_exists("HTTP_AUTHORIZATION", $_SERVER)) {
                if (!empty($_SERVER["HTTP_AUTHORIZATION"]) && strlen($_SERVER["HTTP_AUTHORIZATION"]) > 8) {
                    if (stripos($_SERVER["HTTP_AUTHORIZATION"], "Bearer ") === 0) {
                        $key = substr($_SERVER["HTTP_AUTHORIZATION"], 7);
                        $authorized = $model->isAuthorized($key);
                    }
                }
            }

            if (!$authorized) {
                $response->setHeader("WWW-Authenticate", 'Bearer realm=crossroads.se, charset="UTF-8"');
                $response->setHttpResponseCode(401);
                $response->setBody("Unauthorized");

                return;
            }

            $method = $request->getMethod();
            if (empty($method)) {
                throw new Awardit_Upsert_InputException("Missing method");
            }

            // $params = $request->getParams();
            $params = $model->getJsonBody($request);
            if (empty($params)) {
                $params = $request->getParams();
                if (empty($params)) {
                    throw new Awardit_Upsert_InputException("Missing parameters");
                }
            }

            if (!empty($params["deleted"]) && $params["deleted"] === "disabled") {
                return;
            }

            if (!empty($params["store_code"])) {
                $store = Mage::getConfig()->getNode("stores")->{$params["store_code"]};
                if (!empty($store)) {
                    $localStoreId = intval($store->{"system"}->{"store"}->{"id"});
                    if (!empty($localStoreId)) {
                        Mage::app()->setCurrentStore($localStoreId);
                    } else {
                        throw new Awardit_Upsert_InputException("Unknown store code");
                    }
                } else {
                    throw new Awardit_Upsert_InputException("Unknown store code");
                }
            }

            $matches = [];
            if (preg_match("/^.*product\/([^\/]+)[\/]?$/", $_SERVER["REQUEST_URI"] ?? "", $matches) === 1) {
                $sku = $matches[1] ?? null;
            } else {
                $sku = $params["sku"] ?? null;
            }

            Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);
            $model->setLocalStore($localStore);

            switch (strtoupper($method)) {
                case "PUT":
                    if (empty($sku)) {
                        throw new Awardit_Upsert_InputException("Missing sku!");
                        break;
                    }

                    $result = $model->updateProductAction($params, $sku);
                    break;

                case "POST":
                    $result = $model->createProductAction($params);
                    break;

                case "GET":
                    $result = $model->listProductsAction($params, $sku);
                    $skipBodyInLog = true;
                    break;

                default:
                    throw new Awardit_Upsert_InputException("Unhandeled method:{$method}");
                    break;
            }

            $response->setHttpResponseCode(200);
            $response->setHeader("Content-type", "application/json");
            $response->setBody(json_encode($result, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
        }
        catch (Awardit_Upsert_InputException $e) {
            $response->setHttpResponseCode(400);
            $response->setHeader("Content-type", "application/json");

            $msg = ["message" => $e->getMessage()];

            Mage::logException($e, "upsert-request", Zend_Log::WARN);

            if (Mage::getIsDeveloperMode()) {
                $msg["trace"] = $e->getTraceAsString();
            }

            $response->setBody(json_encode($msg, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
        }
        catch (Throwable $e) {
            $response->setHttpResponseCode(500);
            $response->setHeader("Content-type", "application/json");

            $msg = ["message" => "Internal Server Error"];

            Mage::logException($e, "upsert-request", Zend_Log::ERR);

            if (Mage::getIsDeveloperMode()) {
                $msg["message"] = $e->getMessage();
                $msg["trace"] = $e->getTraceAsString();
            }

            $response->setBody(json_encode($msg, JSON_PRESERVE_ZERO_FRACTION | JSON_UNESCAPED_SLASHES));
        }
        finally {
            // Restore store-code to accurately log
            Mage::app()->setCurrentStore($localStore);
            Mage::log(
                sprintf(
                    "%s %s (%s): %s => %d %s",
                    strtoupper($request->getMethod()),
                    $request->getRequestUri(),
                    json_encode($request->getParams()),
                    $request->getRawBody() ?: "<EMPTY>",
                    $response->getHttpResponseCode(),
                    $skipBodyInLog ? "<SKIPPED>" : $response->getBody()
                ),
                Zend_Log::DEBUG,
                "upsert-request"
            );
        }
    }

}
