<?php

class Awardit_Upsert_Model_Cli_ProductStatus extends Awardit_Integration_Model_Cli {

    protected $_defaultHelper = "awardit_upsert";

    // -m=ProductStatus -f=activateAllStores
    public function CLI_activateAllStores($param): void
    {
        $storeList = Mage::helper($this->_defaultHelper)->getStoresEnabledForTimedPrices();
        foreach (array_keys($storeList) as $storeId) {
            $store = Mage::getModel('core/store')->load($storeId);
            Mage::helper($this->_defaultHelper)->activateProductsWithTimedPricesInStore($store);
        }
    }

    // -m=ProductStatus -f=activateSingleStore -p="storeId:<store-id>"
    public function CLI_activateSingleStore($param): void
    {
        $this->setLimit(Awardit_Integration_Model_Cli_Cron::CRON_DEFAULT_ITERATION_LIMIT);

        $wantedParams = [
            "storeId" => "int"
        ];
        $extractedParams = $this->extractParams($param, $wantedParams);

        if (!empty($extractedParams["storeId"])) {
            if (in_array($extractedParams["storeId"], array_keys(Mage::helper($this->_defaultHelper)->getStoresEnabledForTimedPrices()))) {
                $store = Mage::getModel('core/store')->load($extractedParams["storeId"]);
                Mage::helper($this->_defaultHelper)->activateProductsWithTimedPricesInStore($store);
            } else {
                Mage::log("Store {$store->getId()} not configured to process timed prices!", Zend_Log::ERR, "awardit_upsert");
                echo "Store {$store->getId()} not configured to process timed prices!\n";
            }
        } else {
            Mage::log("Missing parameter!", Zend_Log::ERR, "awardit_upsert");
            echo "Missing parameter!\n";
        }
    }

    // -m=ProductStatus -f=deactivateAllStores
    public function CLI_deactivateAllStores($param): void
    {
        $storeList = Mage::helper($this->_defaultHelper)->getStoresEnabledForTimedPrices();
        foreach (array_keys($storeList) as $storeId) {
            $store = Mage::getModel('core/store')->load($storeId);
            Mage::helper($this->_defaultHelper)->deactivateProductsWithTimedPricesInStore($store);
        }
    }

    // -m=ProductStatus -f=deactivateSingleStore -p="storeId:<store-id>"
    public function CLI_deactivateSingleStore($param): void
    {
        $this->setLimit(Awardit_Integration_Model_Cli_Cron::CRON_DEFAULT_ITERATION_LIMIT);

        $wantedParams = [
            "storeId" => "int"
        ];
        $extractedParams = $this->extractParams($param, $wantedParams);

        if (!empty($extractedParams["storeId"])) {
            if (in_array($extractedParams["storeId"], array_keys(Mage::helper($this->_defaultHelper)->getStoresEnabledForTimedPrices()))) {
                $store = Mage::getModel('core/store')->load($extractedParams["storeId"]);
                Mage::helper($this->_defaultHelper)->deactivateProductsWithTimedPricesInStore($store);
            } else {
                Mage::log("Store {$store->getId()} not configured to process timed prices!", Zend_Log::ERR, "awardit_upsert");
                echo "Store {$store->getId()} not configured to process timed prices!\n";
            }
        } else {
            Mage::log("Missing parameter!", Zend_Log::ERR, "awardit_upsert");
            echo "Missing parameter!\n";
        }
    }

}
