<?php

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Registry;

/**
 * Base GraphQL payment class for Unzer. All methods here are required by abstract class.
 */
abstract class Awardit_Unzer_Model_Graphql_Method_Abstract extends MageQL_Sales_Model_Payment_Abstract
{
    /** @var Awardit_Unzer_Helper_Data */
    protected $helper;

    /**
     * Constructor for class.
     */
    public function __construct()
    {
        $this->helper = Mage::helper('awardit_unzer');
    }

    /**
     * Get method code.
     * @return string
     */
    public function getCode(): string
    {
        return $this->_code;
    }

    /**
     * Get method type.
     * @return string
     */
    public function getMethodTypeName(): string
    {
        return ucfirst($this->_code);
    }

    /**
     * Get result data when setting Unzer as quote payment.
     * @param Registry $registry
     * @return array Result fields
     */
    public function getMutateSetQuotePaymentFields(Registry $registry): array
    {
        return [
            'result' => $this->field("{$this->getMutationResultType()}!", 'Result when setting payment method to Unzer')
                ->setResolver('MageQL\\forwardResolver'),
            'publicKey' => $this->field('ID!', 'The public key for Unzer')
                ->setResolver(function () {
                    return $this->helper->getPublicKey();
                }),
        ];
    }

    /**
     * Resolve result when setting Unzer as quote payment.
     * @param Mage_Sales_Model_Quote $quote
     * @param array $args
     * @param MageQL_Core_Model_Context $ctx
     * @param ResolveInfo $info
     * @return string Result code
     */
    public function mutateSetPaymentMethod(
        Mage_Sales_Model_Quote $quote,
        array $args,
        MageQL_Core_Model_Context $ctx,
        ResolveInfo $info
    ): string
    {
        $model = Mage::getSingleton('mageql_sales/quote');
        try {
            $model->importPaymentData($quote, $this->getCode(), []);
            $model->saveSessionQuote();

            return self::SUCCESS;

        } catch (Mage_Core_Exception $e) {
            $this->helper->log("Failed to set {$this->_code} on quote/{$quote->getId()}: {$e->getMessage()}");
            return $this->translatePaymentError($e);
        }
    }

    /**
     * Additional method fields for Unzer methods.
     * @param Registry $registry
     * @return array
     */
    public function getPaymentMethodFields(Registry $registry): array
    {
        return [];
    }

    /**
     * Additional quote fields for Unzer methods.
     * @param Registry $registry
     * @return array
     */
    public function getQuotePaymentFields(Registry $registry): array
    {
        return [];
    }
}
