<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;
use GraphQL\Utils\SchemaPrinter;
use PHPUnit\Framework\TestCase;
use Spatie\Snapshots\MatchesSnapshots;

class GraphqlTest extends TestCase
{
    use MatchesSnapshots;

    public function setUp(): void
    {
        MagentoManager::reset();
        MagentoManager::init('default');

        $config = new Mage_Core_Model_Config();
        $config->saveConfig('payment/unzer_config/api_key_sandbox', 'sandbox', 'default', 0);
        $config->saveConfig('payment/unzer_config/public_key_sandbox', 'irrelevant', 'default', 0);
        $config->saveConfig('payment/unzer_config/private_key_sandbox', 'irrelevant', 'default', 0);
        $config->saveConfig('payment/unzer_config/return_url', 'https://example.com/my/return/url', 'default', 0);
        $config->saveConfig('payment/unzerCard/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerCard/title', 'My Unzer Card', 'default', 0);
        $config->saveConfig('payment/unzerCard/payment_action', 'authorize', 'default', 0);
        $config->saveConfig('payment/unzerGiropay/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerGiropay/title', 'My Unzer Giropay', 'default', 0);
        $config->saveConfig('payment/unzerBancontact/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerBancontact/title', 'My Unzer Bancontact', 'default', 0);
        $config->saveConfig('payment/unzerEps/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerEps/title', 'My Unzer EPS', 'default', 0);
        $config->saveConfig('payment/unzerIdeal/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerIdeal/title', 'My Unzer iDeal', 'default', 0);
        $config->saveConfig('payment/unzerPayPal/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerPayPal/title', 'My Unzer PayPal', 'default', 0);
        $config->saveConfig('payment/unzerPayPal/payment_action', 'authorize', 'default', 0);
        $config->saveConfig('payment/unzerPayPalExpress/active', '1', 'default', 0);
        $config->saveConfig('payment/unzerPayPalExpress/title', 'My Unzer PayPal Express', 'default', 0);
        $config->saveConfig('payment/unzerPayPalExpress/payment_action', 'authorize', 'default', 0);
        Mage::getConfig()->loadModules()->loadDb()->saveCache(); // Reload config cache
    }

    public function tearDown(): void
    {
        MagentoManager::logQueries();
    }


    /* --------- Order tests --------------------------------------------------------- */

    public function testMutationSchema(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "Mutation") { fields { name type { name } args { name type { name } } } } }'
        );
        $place = $this->findField($result->data->__type->fields, 'placeUnzerOrder');
        $this->assertMatchesJsonSnapshot($place);
        $verify = $this->findField($result->data->__type->fields, 'verifyUnzerOrder');
        $this->assertMatchesJsonSnapshot($verify);
    }


    /* --------- Bancontact tests ---------------------------------------------------- */

    public function testBancontactPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerBancontact") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testBancontactQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerBancontact") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testBancontactSetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerBancontact") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testBancontactSetQuotePaymentResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerBancontactResult") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    /* --------- Card tests ---------------------------------------------------------- */

    public function testCardPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerCard") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testCardQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerCard") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testCardSetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerCard") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testCardSetQuotePaymentResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerCardResult") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    /* --------- EPS tests ----------------------------------------------------------- */

    public function testEpsPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerEps") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testEpsQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerEps") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testEpsSetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerEps") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testEpsSetQuotePaymentResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerEpsResult") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    /* --------- Giropay tests ------------------------------------------------------- */

    public function testGiropayPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerGiropay") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testGiropayQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerGiropay") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testGiropaySetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerGiropay") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testGiropaySetQuotePaymentResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerGiropayResult") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    /* --------- iDeal tests --------------------------------------------------------- */

    public function testIdealPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerIdeal") { name fields { name type { name } } } }'
    }

    public function testIdealQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerIdeal") { name fields { name type { name } } } }'
    }

    public function testIdealSetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerIdeal") { name fields { name type { name } } } }'
    }

    public function testIdealSetQuotePaymentResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerIdealResult") { name fields { name type { name } } } }'
    }


    /* --------- PayPal tests -------------------------------------------------------- */

    public function testPayPalPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerPayPal") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    public function testPayPalQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerPayPal") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testPayPalSetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerPayPal") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testPayPalSetQuotePaymentResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerPayPalResult") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    /* --------- PayPal Express tests ------------------------------------------------ */

    public function testPayPalExpressPaymentMethod(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "PaymentMethodUnzerPayPalExpress") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testPayPalExpressQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "QuotePaymentUnzerPayPalExpress") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testPayPalExpressSetQuotePayment(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerPayPalExpress") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }

    public function testPayPalExpressSetQuotePaymentdResult(): void
    {
        $result = $this->runQuery(
            '{ __type(name: "MutationSetQuotePaymentMethodUnzerPayPalExpressResult") { name fields { name type { name } } } }'
        );
        $this->assertMatchesJsonSnapshot($result);
    }


    /* --------- Helper methods ------------------------------------------------------ */

    private function runQuery(string $query): object
    {
        $response = MagentoManager::runRequest(new Request("POST /graphql", [
            "Content-Type" => "application/graphql",
        ], $query), 'default');
        $this->assertEquals(200, $response->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $response->getHeader("Content-Type"));
        return json_decode($response->getBody());
    }

    private function findField(array $fields, string $name): ?object
    {
        foreach ($fields as $field) {
            if ($field->name == $name) {
                return $field;
            }
        }
        return null;
    }
}
