<?php

/**
 * Method class for Unzer iDeal.
 * @see https://docs.unzer.com/payment-methods/ideal/
 */
class Awardit_Unzer_Model_Method_Ideal extends Awardit_Unzer_Model_Method_Abstract
{
    protected $_code = 'unzerIdeal';
    protected $_canAuthorize = false;

    /**
     * To check billing country is allowed for the payment method
     * @param string $country
     * @return bool
     */
    public function canUseForCountry($country): bool
    {
        return parent::canUseForCountry($country) && $country == 'NL';
    }

    /**
     * Check method for processing with base currency
     * @param string $currencyCode
     * @return boolean
     */
    public function canUseForCurrency($currencyCode): bool
    {
        return parent::canUseForCurrency($currencyCode) && $currencyCode == 'EUR';
    }
}
