<?php

/**
 * Method class for Unzer EPS.
 * @see https://docs.unzer.com/payment-methods/eps/
 */
class Awardit_Unzer_Model_Method_Eps extends Awardit_Unzer_Model_Method_Abstract
{
    protected $_code = 'unzerEps';
    protected $_canAuthorize = false;

    /**
     * To check billing country is allowed for the payment method
     * @param string $country
     * @return bool
     */
    public function canUseForCountry($country): bool
    {
        return parent::canUseForCountry($country) && $country == 'AT';
    }

    /**
     * Check method for processing with base currency
     * @param string $currencyCode
     * @return boolean
     */
    public function canUseForCurrency($currencyCode): bool
    {
        return parent::canUseForCurrency($currencyCode) && $currencyCode == 'EUR';
    }
}
