<?php

/**
 * Listens to webhooks sent from Unzer when something changes in their end.
 */
class Awardit_Unzer_IpnController extends Mage_Core_Controller_Front_Action
{
    /** @var Awardit_Unzer_Helper_Data */
    protected $helper;

    /**
     * Receive webhook from Unzer.
     * @todo: Only logs request at this time. We need to figure out what we get here.
     */
    public function indexAction(): void
    {
        $this->helper = Mage::helper('awardit_unzer');
        $event_json = $this->getRequest()->getRawBody();
        $this->helper->log("Webhook {$event_json}");

        $resource = $this->helper->unzer()->fetchResourceFromEvent($event_json);
        $webhook = json_decode($event_json);

        $this->getResponse()->setHeader('Content-Type', 'application/json')->setBody('Ok.');
    }
}
