<?php

/**
 * Used to create select source for Unzer locales.
 * @see https://docs.unzer.com/reference/localization/
 */
class Awardit_Unzer_Model_Source_Locale
{
    /**
     * Options getter.
     * @return array
     */
    public function toOptionArray(): array
    {
        $options = [];
        foreach ($this->toArray() as $key => $name) {
            $options[] = ['value' => $key, 'label' => $name];
        }
        return $options;
    }

    /**
     * Get options in "key-value" format.
     * @return array
     */
    public function toArray(): array
    {
        $helper = Mage::helper('awardit_unzer');
        return [
            'cs-CZ' => $helper->__('Czech'),
            'nl-NL' => $helper->__('Dutch'),
            'en-GB' => $helper->__('English (GB)'),
            'en-US' => $helper->__('English (US)'),
            'fr-FR' => $helper->__('French'),
            'de-DE' => $helper->__('German'),
            'it-IT' => $helper->__('Italian'),
            'pl-PL' => $helper->__('Polish'),
            'pt-PT' => $helper->__('Portuguese'),
            'sk-SK' => $helper->__('Slovakian'),
            'es-ES' => $helper->__('Spanish'),
        ];
    }
}
