<?php

class Awardit_Tradedoubler_Model_Observer extends Mage_Core_Model_Abstract {

    /**
     * Observer of product changes, possibly invalidating feed cache.
     */
    public function updateProduct(Varien_Event_Observer $observer): void {
        /** @var Mage_Catalog_Model_Product */
        $product = $observer->getProduct();

        $cache = Mage::app()->getCacheInstance();
        $data = $product->getData();
        $orig = $product->getOrigData();

        if (empty($data["tradedoubler_feed"]) && empty($orig["tradedoubler_feed"])) {
            // Is not and was not mapped to tradedoubler - ignore
            return;
        }
        if ($data["tradedoubler_feed"] != $orig["tradedoubler_feed"]) {
            // Changed feed, invalidate both old and new
            $cache->remove("tradedoubler_feed_{$data['tradedoubler_feed']}");
            $cache->remove("tradedoubler_feed_{$orig['tradedoubler_feed']}");
            return;
        }
        $check = [
            "tradedoubler_categories" => null,
            "name" => null,
            "description" => null,
            "price" => null,
            "sku" => null,
            "url_path" => null,
        ];
        $diff = array_diff(
            array_intersect_key($data, $check),
            array_intersect_key($orig, $check),
        );

        $img_d = count($data["media_gallery"]["images"]) > 0
            ? $data["media_gallery"]["images"][0]["file"]
            : null;
        $img_o = count($orig["media_gallery"]["images"]) > 0
            ? $orig["media_gallery"]["images"][0]["file"]
            : null;
        $image_check = $img_d == $img_o;
        if (!empty($diff) || !$image_check) {
            // Relevant data has changed, invalidate
            $cache->remove("tradedoubler_feed_{$orig['tradedoubler_feed']}");
        }
    }

    /**
     * Observer of product delete, invalidating feed cache.
     */
    public function deleteProduct(Varien_Event_Observer $observer): void {
        /** @var Mage_Catalog_Model_Product */
        $product = $observer->getProduct();

        $cache = Mage::app()->getCache();
        $data = $product->getData();

        if ($data["tradedoubler_feed"]) {
            $cache->remove("tradedoubler_feed_{$data['tradedoubler_feed']}");
            return;
        }
    }
}
