<?php

class Awardit_Tradedoubler_Block_Adminhtml_Categories extends Varien_Data_Form_Element_Abstract {

    /**
     * Generate html for category tree view.
     * @return string Html code.
     */
    public function getElementHtml(): string
    {
        $helper = Mage::helper("awardit_tradedoubler");
        $tree = Mage::getModel("awardit_tradedoubler/attribute_source_categories")->getTree();
        $this->addClass('select tree');

        // Clean up values
        $values = $helper->parseCategories($this->getValue());

        ob_start();

        ?>
        <input type="hidden" name="product[tradedoubler_categories][]" id="tradedoubler_categories" value="<?php echo implode(",", $values) ?>">
        <div id="tradedoubler-categories" class="tree"></div>

        <script type="text/javascript">
            var selected = <?php echo json_encode($values) ?>;

            Ext.EventManager.onDocumentReady(function() {

                var tree = new Ext.tree.TreePanel('tradedoubler-categories', {
                    animate: true,
                    enableDD: false,
                    containerScroll: true,
                    rootUIProvider: Ext.tree.CheckboxNodeUI,
                    selModel: new Ext.tree.CheckNodeMultiSelectionModel(),
                    rootVisible: true
                });

                tree.on('check', function(node) {
                    if(node.attributes.checked) {
                        categoryAdd(node.id);
                    } else {
                        categoryRemove(node.id);
                    }
                    varienElementMethods.setHasChanges(node.getUI().checkbox);
                }, tree);

                // set the root node
                var root = new Ext.tree.TreeNode({
                    text: <?php echo json_encode($tree["text"]); ?>,
                    draggable: false,
                    checked: selected.indexOf(<?php echo json_encode($tree["id"]); ?>) != -1,
                    id: <?php echo json_encode($tree["id"]); ?>,
                    disabled: false,
                    uiProvider: Ext.tree.CheckboxNodeUI
                });

                tree.setRootNode(root);
                buildCategoryTree(root, <?php echo json_encode($tree['children']); ?>);
                tree.addListener('click', categoryClick.createDelegate(this));

                // render the tree
                tree.render();
                root.expand();
            });
            function buildCategoryTree(parent, config) {
                if (!config) return null;

                if (parent && config.length) {
                    for (var i = 0; i < config.length; i++){
                        config[i].uiProvider = Ext.tree.CheckboxNodeUI;

                        if (selected.indexOf(config[i].id) != -1) {
                            config[i].checked = true;
                            var p = parent;
                            while (p != null) {
                                p.expanded = true;
                                p = p.parentNode;
                            }
                        }

                        var node = new Ext.tree.TreeNode(config[i]);

                        parent.appendChild(node);
                        node.loader = node.getOwnerTree().loader;
                        if (config[i].children) {
                            buildCategoryTree(node, config[i].children);
                        }
                    }
                }
            }
            function categoryClick(node, e) {
                if (node.disabled) {
                    return;
                }
                node.getUI().check(!node.getUI().checked());
                varienElementMethods.setHasChanges(Event.element(e), e);
            };
            function categoryAdd(id) {
                selected.push(id);
                $('tradedoubler_categories').value = selected.join(',');
            }
            function categoryRemove(id) {
                while (selected.indexOf(id) != -1) {
                    selected.splice(selected.indexOf(id), 1);
                }
                $('tradedoubler_categories').value = selected.join(',');
            }
        </script>

        <?php

        return ob_get_clean();
    }
}
