<?php

$installer = $this;
$installer->startSetup();

// Create "categories" attribute
$installer->addAttribute(Mage_Catalog_Model_Product::ENTITY, 'tradedoubler_categories', [
    'group'                     => 'Tradedoubler',
    'type'                      => 'text',
    'backend'                   => 'eav/entity_attribute_backend_array',
    'label'                     => 'Categories',
    'input'                     => 'multiselect',
    'input_renderer'            => 'awardit_tradedoubler/adminhtml_categories',
    'source'                    => 'awardit_tradedoubler/attribute_source_categories',
    'global'                    => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'visible'                   => true,
    'required'                  => false,
    'default'                   => null,
    'sort_order'                => 110,
    'is_configurable'           => false,
    'used_in_product_listing'   => true,
]);
// Model has to be set manually
$installer->updateTableRow(
    'eav/attribute',
    'attribute_code',
    'tradedoubler_categories',
    'attribute_model',
    'awardit_tradedoubler/attribute',
);

$installer->endSetup();
