<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Awardit_Tradedoubler_Model_Schema extends MageQL_Core_Model_Schema_Abstract {

    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "TradedoublerInfo":
            return $this->object("Tradedoubler settings and info");
        case "TradedoublerEvents":
            return $this->object("Tradedoubler settings and info");
        }
        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "StoreInfo":
            return [
                "tradedoubler" => $this->field(
                    "TradedoublerInfo",
                    "Tradedoubler settings and info"
                )
                    ->setResolver(function(): ?string {
                        $enabled = (bool)Mage::getStoreConfig('awardit_tradedoubler/tradedoubler_general/enabled');
                        $organization_id = Mage::getStoreConfig('awardit_tradedoubler/tradedoubler_general/organization_id');
                        if (!$enabled || empty($organization_id)) {
                            return null;
                        }
                        return $organization_id;
                    }),

            ];
        case "TradedoublerInfo":
            return [
                "organizationId" => $this->field("String!", "Organization ID")
                    ->setResolver(function(string $organization_id): string {
                        return $organization_id;
                    }),
                "programId" => $this->field("String", "Program ID")
                    ->setResolver(function(): ?string {
                        $program_id = Mage::getStoreConfig('awardit_tradedoubler/tradedoubler_general/program_id');
                        return $program_id ?: null;
                    }),
                "events" => $this->field("TradedoublerEvents", "Event keys")
                    ->setResolver(function() {
                        return [
                            'sale' => Mage::getStoreConfig('awardit_tradedoubler/tradedoubler_tracking/event_sale'),
                            'lead' => Mage::getStoreConfig('awardit_tradedoubler/tradedoubler_tracking/event_lead'),
                        ];
                    }),
            ];
        case "TradedoublerEvents":
            return [
                "sale" => $this->field("String", "Sale event key")
                    ->setResolver(function(array $keys) {
                        return $keys['sale'] ?: null;
                    }),
                "lead" => $this->field("String", "Lead event key")
                    ->setResolver(function(array $keys) {
                        return $keys['lead'] ?: null;
                    }),
            ];
        }

        return [];
    }
}
