# Tradedoubler

## Requesting settings and info via GraphQL

The following query will return all settings available for GraphQL.

```graphql
query {
    info {
        tradedoubler {
          organizationId
          programId
          events {
            sale 
            lead
          }
        }
    }
}
```
Will return something like below.
If not active or organisation ID is missing, it will return null.
Most properties can also be null if not registered in admin.

```json
{
  "data": {
    "info": {
      "tradedoubler": {
        "organizationId": "2333950",
        "programId": null,
        "events": {
          "sale": "429722",
          "lead": "429754"
        }
      }
    }
  }
}
```

## Basic tracking

Some code snippets must be inserted in front end to enable tracking.

### Initialise tracking cookie

All landing pages (i.e. pages that an end user might end up when clicking a Tradedoubler link) **MUST** include the code snippet below.
If the script has been run once on a end user sessions, it can be skipped during the same session.

```javascript
<!-- Start Tradedoubler Landing Page Tag Insert on all landing pages to handle first party cookie-->
<script language="JavaScript">
(function(i,s,o,g,r,a,m){i['TDConversionObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script', 'https://svht.tradedoubler.com/tr_sdk.js', 'tdconv');
</script>
<script src="https://swrap.tradedoubler.com/wrap?id=" async></script>
<!-- End Tradedoubler tag-->
```

### Sale conversion

The order confirmation page, or equivalent page shown to user after a succesful purchase, **MUST** include the snippet below.
Note that the script uses variables, both from settings gotten from query above and for purchased order. 

* `ORDER_NUMBER`, `ORDER_VALUE`, `CURRENCY` and `VOUCHER_CODE` are from current order.
* `ORGANIZATION_ID` and `EVENT_SALE` are from GraphQL request.

```javascript
<script language="JavaScript">
    var TDOrderNumber='[ORDER_NUMBER]';
    var TDOrderValue='[ORDER_VALUE]';
    var TDCurrency='[CURRENCY]';
    var TDVoucher='[VOUCHER_CODE]';

        (function(i,s,o,g,r,a,m){i['TDConversionObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script', 'https://svht.tradedoubler.com/tr_sdk.js', 'tdconv');
        tdconv('init', '[ORGANIZATION_ID]', {'element': 'iframe' });
        tdconv('track', 'sale',
{'transactionId':TDOrderNumber,'ordervalue':TDOrderValue,'currency':TDCurrency,'event':'[EVENT_SALE]','voucher':TDVoucher});

var TDConf = TDConf || {};
TDConf.Config = {
  orderId: TDOrderNumber,
  orderValue: TDOrderValue,
  currency: TDCurrency,
  voucherCode: TDVoucher
};

function getCookie(e){var n=document.cookie,i=e+"=",o=n.indexOf("; "+i);if(-1==o){if(0!=(o=n.indexOf(i)))return null}else o+=2;var t=document.cookie.indexOf(";",o);return-1==t&&(t=n.length),unescape(n.substring(o+i.length,t))}
var tduid=getCookie('tduid');
var ab = document.createElement('img');
ab.src = 'https://img-statics.com/report?o=[ORGANIZATION_ID]&e=[EVENT_SALE]&ordnum='+TDOrderNumber+'&ordval='+TDOrderValue+'&curr='+TDCurrency+'&tduid='+tduid;
</script>

<script src="https://swrap.tradedoubler.com/wrap?id=" async> </script>
```

### Lead conversion

End user actions that indicate active involvement but do not include transfer of money are considered "leads".
This might include filling in a declaration of interest form, signing up for newsletter, or similar actions.
The following snippet should be included on pages shown after such action has been successfully performed.
Note that the script uses variables, both from settings gotten from query above and for purchased order. 

* `LEAD_NUMBER` is the id of performed action.
* `ORGANIZATION_ID` and `EVENT_LEAD` are from GraphQL request.

```javascript
<script language="JavaScript">
    var TDLeadNumber='[LEAD_NUMBER]';

        (function(i,s,o,g,r,a,m){i['TDConversionObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script', 'https://svht.tradedoubler.com/tr_sdk.js', 'tdconv');
        tdconv('init', '[ORGANIZATION_ID]', {'element': 'iframe' });
        tdconv('track', 'lead',
{'transactionId':TDLeadNumber,'event':'[EVENT_LEAD]'});

var TDConf = TDConf || {};
TDConf.Config = {
  orderId: TDLeadNumber
};

function getCookie(e){var n=document.cookie,i=e+"=",o=n.indexOf("; "+i);if(-1==o){if(0!=(o=n.indexOf(i)))return null}else o+=2;var t=document.cookie.indexOf(";",o);return-1==t&&(t=n.length),unescape(n.substring(o+i.length,t))}
var tduid=getCookie(tduid);
var ab = document.createElement('img');
ab.src = 'https://img-statics.com/report?o=[ORGANIZATION_ID]&e=[EVENT_LEAD]&ordnum='+TDLeadNumber+'&tduid='+tduid+'</script>

<script src="https://swrap.tradedoubler.com/wrap?id=" async> </script>
```

### Google Tag Manager (GTM)

The Tradedoubler tracking snippets can be used in GTM instead of being put directly in source code.
GTM must already be implemented in code, and provided with relevant variables used in snippets.


### Future upgrades under consideration

* Product integration - automatically update product registry in Tradedoubler (default: manual in TD admin)
* Offline tracking - allows us to register sales and leads as server-server request
* Remarketing
* …More?
