<?php

use Mage_Adminhtml_Model_System_Config_Backend_Serialized_Array as Serialized_Array;

class Awardit_Tradedoubler_Model_Attribute_Backend_Events extends Serialized_Array
{
    protected function _beforeSave()
    {
        // If an event is removed from configuration,
        // it must also be removed from any products using it.
        $parts = explode('/', $this->getPath());
        switch (array_pop($parts)) {
            case 'events_sale':
                $attribute = 'tradedoubler_event_sale';
                break;
            case 'events_lead':
                $attribute = 'tradedoubler_event_lead';
                break;
            default:
                return;
        }
        /** @var array */
        $source = $this->getValue();
        $available = array_values(array_filter(array_map(function (array $item) {
            return isset($item['event_id']) ? $item['event_id'] : null;
        }, $source)));

        $collection = Mage::getResourceModel('catalog/product_collection');
        $collection->addAttributeToFilter($attribute, ['notnull' => true]);
        if (!empty($available)) {
            $collection->addAttributeToFilter($attribute, ['nin' => $available]);
        }

        foreach ($collection as $product) {
            $product->setData($attribute, null);
            $product->save();
        }

        parent::_beforeSave();
    }
}
