<?php

declare(strict_types=1);

class Awardit_Tradedoubler_Model_Attribute extends Mage_Catalog_Model_Resource_Eav_Attribute
{
    /**
     * Hide tab if Tradedoubler not enabled
     * @return bool If attribute is visible
     */
    public function getIsVisible(): bool
    {
        $helper = Mage::helper("awardit_tradedoubler");
        $store_id = Mage::app()->getRequest()->getParam('store');
        $product_id = Mage::app()->getRequest()->getParam('id');
        $parent_ids = Mage::getResourceSingleton('catalog/product_type_configurable')
            ->getParentIdsByChild($product_id);
        return $helper->isEnabled($store_id) && parent::getIsVisible() && empty($parent_ids);
    }
}
