<?php

$installer = $this;
$installer->startSetup();

// Create "sale event" attribute
$installer->addAttribute(Mage_Catalog_Model_Product::ENTITY, 'tradedoubler_event_sale', [
    'group'                     => 'Tradedoubler',
    'type'                      => 'varchar',
    'backend'                   => '',
    'label'                     => 'Sale event',
    'input'                     => 'select',
    'source'                    => 'awardit_tradedoubler/attribute_source_saleEvents',
    'global'                    => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'visible'                   => true,
    'required'                  => false,
    'default'                   => "",
    'sort_order'                => 10,
    'is_configurable'           => false,
    'used_in_product_listing'   => true,
]);
// Model has to be set manually
$installer->updateTableRow(
    'eav/attribute',
    'attribute_code',
    'tradedoubler_event_sale',
    'attribute_model',
    'awardit_tradedoubler/attribute'
);

// Create "lead event" attribute
$installer->addAttribute(Mage_Catalog_Model_Product::ENTITY, 'tradedoubler_event_lead', [
    'group'                     => 'Tradedoubler',
    'type'                      => 'varchar',
    'backend'                   => '',
    'label'                     => 'Lead event',
    'input'                     => 'select',
    'source'                    => 'awardit_tradedoubler/attribute_source_leadEvents',
    'global'                    => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    'visible'                   => true,
    'required'                  => false,
    'default'                   => "",
    'sort_order'                => 20,
    'is_configurable'           => false,
    'used_in_product_listing'   => true,
]);
// Model has to be set manually
$installer->updateTableRow(
    'eav/attribute',
    'attribute_code',
    'tradedoubler_event_lead',
    'attribute_model',
    'awardit_tradedoubler/attribute'
);

$installer->endSetup();
