<?php

class Awardit_Tradedoubler_Model_Attribute_Source_Feed
    extends Mage_Eav_Model_Entity_Attribute_Source_Abstract
{
    /**
     * Get list of all available feeds
     *
     * @return array
     */
    public function getAllOptions()
    {
        $helper = Mage::helper("awardit_tradedoubler");
        $store_id = Mage::app()->getRequest()->getParam('store');

        if (!$helper->isCatalogEnabled($store_id)) {
            // Block if catalog not enabled
            return [0 => "({$helper->__('Disabled')})"];
        }

        $general = $helper->getGeneralSettings($store_id);
        $catalog = $helper->getCatalogSettings($store_id);

        try {
            // Retrieve feeds from Tradedoubler
            $return = [0 => "({$helper->__('None')})"];
            $client = Mage::getModel('awardit_tradedoubler/api_client');
            foreach ($client->getFeeds($general["api_token"]) as $feed) {
                if ($feed->deleted) {
                    continue;
                }
                $return[$feed->feedId] = "{$feed->name} ({$feed->feedId})";
            }
            return $return;

        } catch (Throwable $t) {
            // Don't crash if Tradedoubler API is unavailable
            return [0 => "({$helper->__('Temporarily disabled')})"];
        }
    }
}
