# Slack Integration

This module provides methods to write messages into Slack.

## Install

Install as dependency `composer require awardit/slack-integration`.


## Setup

1. Create an App in Slack. It must have scopes `channels:read` and `chat:write` enabled.
1. Generate an OAuth token for the App, and store it in System > Configuration > Awardit > Slack integration.
1. Add the App to the Slack channels it should be able to write to.


## Usage

```php
// Get the Slack helper
$slack = Mage::helper('awardit_slack');

// Get channels that Magento can write to.
$slack->getAvailableChannels();

// Send message to a channel.
$slack->postInChannel('channel-id-or-name', 'my message');
```


## Config support

The module includes a config source provider that can be used by a module
to select Slack channel for it to use. In `system.xml` add a
`source_model` property to the field that should contain selected Slack channel.

```xml
<fields>
    <my_slack_channel>
        <label>Slack channel to use</label>
        <frontend_type>select</frontend_type>
        <source_model>awardit_slack/source_channels</source_model>
    </my_slack_channel>
</fields>
```