<?php

/**
 * Used to create select source for available Slack channels.
 */
class Awardit_Slack_Model_Source_Channels
{
    /**
     * Options getter.
     * @return array
     */
    public function toOptionArray(): array
    {
        $options = [['value' => '', 'label' => '']];
        foreach (Mage::helper('awardit_slack')->getAvailableChannels() as $key => $name) {
            $options[] = ['value' => $key, 'label' => $name];
        }
        return $options;
    }

    /**
     * Get options in "key-value" format.
     * @return array
     */
    public function toArray(): array
    {
        return array_merge(['' => ''], Mage::helper('awardit_slack')->getAvailableChannels());
    }
}
